/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.layouter.style.resolver.computed.text;

import org.jfree.layouting.LayoutProcess;
import org.jfree.layouting.input.style.StyleKey;
import org.jfree.layouting.input.style.keys.border.BorderWidth;
import org.jfree.layouting.input.style.keys.font.FontStyleKeys;
import org.jfree.layouting.input.style.keys.text.TextDecorationWidth;
import org.jfree.layouting.input.style.values.CSSConstant;
import org.jfree.layouting.input.style.values.CSSNumericType;
import org.jfree.layouting.input.style.values.CSSNumericValue;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.layouter.model.LayoutElement;
import org.jfree.layouting.layouter.style.resolver.computed.ConstantsResolveHandler;

public class TextDecorationWidthResolveHandler
extends ConstantsResolveHandler {
    public TextDecorationWidthResolveHandler() {
        this.addValue(BorderWidth.THIN, CSSNumericValue.createValue(CSSNumericType.PT, 0.5));
        this.addValue(BorderWidth.MEDIUM, CSSNumericValue.createValue(CSSNumericType.PT, 1.0));
        this.addValue(BorderWidth.THICK, CSSNumericValue.createValue(CSSNumericType.PT, 1.5));
        this.addValue(TextDecorationWidth.DASH, CSSNumericValue.createValue(CSSNumericType.PT, 0.75));
        this.addValue(TextDecorationWidth.BOLD, CSSNumericValue.createValue(CSSNumericType.PT, 1.25));
        this.setFallback(CSSNumericValue.ZERO_LENGTH);
    }

    @Override
    public StyleKey[] getRequiredStyles() {
        return new StyleKey[]{FontStyleKeys.FONT_SIZE};
    }

    @Override
    protected CSSValue resolveValue(LayoutProcess layoutProcess, LayoutElement layoutElement, StyleKey styleKey) {
        CSSValue cSSValue = layoutElement.getLayoutContext().getValue(styleKey);
        if (cSSValue instanceof CSSConstant) {
            return super.resolveValue(layoutProcess, layoutElement, styleKey);
        }
        return cSSValue;
    }
}

