/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.report.pentaho.styles;

import org.jfree.layouting.input.style.values.CSSNumericType;
import org.jfree.layouting.input.style.values.CSSNumericValue;

public class LengthCalculator {
    private double millimeter;
    private double point;
    private double pixel;

    public void add(CSSNumericValue value) {
        if (value == null) {
            return;
        }
        CSSNumericType numericType = value.getType();
        if (numericType == CSSNumericType.CM) {
            this.millimeter += value.getValue() * 10.0;
        } else if (numericType == CSSNumericType.MM) {
            this.millimeter += value.getValue();
        } else if (numericType == CSSNumericType.PT) {
            this.point += value.getValue();
        } else if (numericType == CSSNumericType.PC) {
            this.point += 12.0 * value.getValue();
        } else if (numericType == CSSNumericType.INCH) {
            this.point += 72.0 * value.getValue();
        } else if (numericType == CSSNumericType.PX) {
            this.pixel += value.getValue();
        }
    }

    public CSSNumericValue getResult() {
        if (this.pixel == 0.0 && this.point == 0.0) {
            return CSSNumericValue.createValue((CSSNumericType)CSSNumericType.MM, (double)this.millimeter);
        }
        if (this.pixel == 0.0 && this.millimeter == 0.0) {
            return CSSNumericValue.createValue((CSSNumericType)CSSNumericType.PT, (double)this.point);
        }
        if (this.point == 0.0 && this.millimeter == 0.0) {
            return CSSNumericValue.createValue((CSSNumericType)CSSNumericType.PX, (double)this.pixel);
        }
        double result = this.point;
        result += this.millimeter * 10.0 * 72.0 / 254.0;
        return CSSNumericValue.createValue((CSSNumericType)CSSNumericType.PT, (double)(result += this.pixel * 72.0 / 96.0));
    }
}

