/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.report.pentaho.parser.text;

import java.util.ArrayList;
import java.util.List;
import org.jfree.report.structure.Element;
import org.jfree.report.structure.Section;
import org.jfree.report.structure.StaticText;
import org.libreoffice.report.pentaho.parser.ElementReadHandler;
import org.libreoffice.report.pentaho.parser.rpt.FixedContentReadHandler;
import org.libreoffice.report.pentaho.parser.rpt.FormattedTextReadHandler;
import org.libreoffice.report.pentaho.parser.rpt.ImageReadHandler;
import org.libreoffice.report.pentaho.parser.rpt.SubDocumentReadHandler;
import org.libreoffice.report.pentaho.parser.text.TextContentReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.XmlReadHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class NoCDATATextContentReadHandler
extends ElementReadHandler {
    private Section section;
    private List<Object> children = new ArrayList<Object>();
    private boolean copyType;

    public NoCDATATextContentReadHandler(Section section, boolean copyType) {
        this.section = section;
        this.copyType = copyType;
    }

    public NoCDATATextContentReadHandler(Section section) {
        this(section, false);
    }

    public NoCDATATextContentReadHandler() {
        this(new Section(), true);
    }

    @Override
    protected void startParsing(Attributes attrs) throws SAXException {
        super.startParsing(attrs);
        Element element = this.getElement();
        if (this.copyType) {
            this.copyElementType(element);
        }
        this.copyAttributes(attrs, element);
    }

    protected XmlReadHandler getHandlerForChild(String uri, String tagName, Attributes atts) throws SAXException {
        if ("http://openoffice.org/2005/report".equals(uri)) {
            if ("fixed-content".equals(tagName)) {
                FixedContentReadHandler fixedContentReadHandler = new FixedContentReadHandler();
                this.children.add((Object)fixedContentReadHandler);
                return fixedContentReadHandler;
            }
            if ("formatted-text".equals(tagName)) {
                FormattedTextReadHandler formattedTextReadHandler = new FormattedTextReadHandler();
                this.children.add((Object)formattedTextReadHandler);
                return formattedTextReadHandler;
            }
            if ("image".equals(tagName)) {
                ImageReadHandler imageReadHandler = new ImageReadHandler();
                this.children.add((Object)imageReadHandler);
                return imageReadHandler;
            }
            if ("sub-document".equals(tagName)) {
                SubDocumentReadHandler subDocReadHandler = new SubDocumentReadHandler(this.section);
                return subDocReadHandler;
            }
        }
        if ("urn:oasis:names:tc:opendocument:xmlns:drawing:1.0".equals(uri)) {
            ElementReadHandler readHandler = "image".equals(tagName) ? new ImageReadHandler() : new NoCDATATextContentReadHandler();
            this.children.add((Object)readHandler);
            return readHandler;
        }
        TextContentReadHandler readHandler = new TextContentReadHandler();
        this.children.add((Object)readHandler);
        return readHandler;
    }

    public List<Object> getChildren() {
        return this.children;
    }

    protected void doneParsing() throws SAXException {
        for (int i = 0; i < this.children.size(); ++i) {
            Object o = this.children.get(i);
            if (o instanceof ElementReadHandler) {
                ElementReadHandler handler = (ElementReadHandler)((Object)o);
                this.section.addNode(handler.getElement());
                continue;
            }
            if (!(o instanceof StaticText)) continue;
            this.section.addNode((StaticText)o);
        }
    }

    @Override
    public Element getElement() {
        return this.section;
    }
}

