/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.report.pentaho.parser.style;

import java.util.ArrayList;
import java.util.List;
import org.jfree.report.modules.factories.report.flow.SectionReadHandler;
import org.jfree.report.structure.Element;
import org.libreoffice.report.pentaho.model.OfficeStyles;
import org.libreoffice.report.pentaho.parser.ElementReadHandler;
import org.libreoffice.report.pentaho.parser.data.DataStyleReadHandler;
import org.libreoffice.report.pentaho.parser.style.OfficeStyleReadHandler;
import org.libreoffice.report.pentaho.parser.style.PageLayoutReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.AbstractXmlReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.XmlReadHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class OfficeStylesReadHandler
extends ElementReadHandler {
    private final List<OfficeStyleReadHandler> textStyleChildren;
    private final List<DataStyleReadHandler> dataStyleChildren;
    private final List<SectionReadHandler> otherStyleChildren;
    private final List<PageLayoutReadHandler> pageLayoutChildren;
    private final OfficeStyles officeStyles;

    public OfficeStylesReadHandler(OfficeStyles officeStyles) {
        this.officeStyles = officeStyles;
        this.pageLayoutChildren = new ArrayList<PageLayoutReadHandler>();
        this.dataStyleChildren = new ArrayList<DataStyleReadHandler>();
        this.textStyleChildren = new ArrayList<OfficeStyleReadHandler>();
        this.otherStyleChildren = new ArrayList<SectionReadHandler>();
    }

    protected XmlReadHandler getHandlerForChild(String uri, String tagName, Attributes atts) throws SAXException {
        if ("urn:oasis:names:tc:opendocument:xmlns:style:1.0".equals(uri)) {
            if ("style".equals(tagName)) {
                OfficeStyleReadHandler xrh = new OfficeStyleReadHandler();
                this.textStyleChildren.add(xrh);
                return xrh;
            }
            if ("page-layout".equals(tagName)) {
                PageLayoutReadHandler prh = new PageLayoutReadHandler();
                this.pageLayoutChildren.add(prh);
                return prh;
            }
        } else if ("urn:oasis:names:tc:opendocument:xmlns:datastyle:1.0".equals(uri)) {
            DataStyleReadHandler xrh = new DataStyleReadHandler(false);
            this.dataStyleChildren.add(xrh);
            return xrh;
        }
        SectionReadHandler genericReadHander = new SectionReadHandler();
        this.otherStyleChildren.add(genericReadHander);
        return genericReadHander;
    }

    protected void doneParsing() throws SAXException {
        AbstractXmlReadHandler handler;
        int i;
        for (i = 0; i < this.textStyleChildren.size(); ++i) {
            handler = this.textStyleChildren.get(i);
            this.officeStyles.addStyle(handler.getOfficeStyle());
        }
        for (i = 0; i < this.pageLayoutChildren.size(); ++i) {
            handler = this.pageLayoutChildren.get(i);
            this.officeStyles.addPageStyle(handler.getPageLayout());
        }
        for (i = 0; i < this.dataStyleChildren.size(); ++i) {
            handler = this.dataStyleChildren.get(i);
            this.officeStyles.addDataStyle(handler.getDataStyle());
        }
        for (i = 0; i < this.otherStyleChildren.size(); ++i) {
            handler = this.otherStyleChildren.get(i);
            this.officeStyles.addOtherNode((Element)handler.getNode());
        }
    }

    @Override
    public Element getElement() {
        return this.officeStyles;
    }
}

