/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.util.HashMap;
import java.util.Map;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathException;
import javax.xml.xpath.XPathFactory;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.OsmServerReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.XmlParsingException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OsmServerUserPreferencesReader
extends OsmServerReader {
    public static Map<String, String> buildFromXML(Document document) throws XmlParsingException {
        try {
            XPath xpath = XPathFactory.newInstance().newXPath();
            HashMap<String, String> result = new HashMap<String, String>();
            NodeList xmlNodeList = (NodeList)xpath.compile("/osm/preferences/preference").evaluate(document, XPathConstants.NODESET);
            if (xmlNodeList != null) {
                for (int i = 0; i < xmlNodeList.getLength(); ++i) {
                    Node xmlNode = xmlNodeList.item(i);
                    String k = OsmServerUserPreferencesReader.getAttribute(xmlNode, "k");
                    if (k == null) {
                        throw new XmlParsingException(I18n.tr("Missing attribute ''{0}'' on XML tag ''{1}''.", "k", "preference"));
                    }
                    String v = OsmServerUserPreferencesReader.getAttribute(xmlNode, "v");
                    if (v == null) {
                        throw new XmlParsingException(I18n.tr("Missing attribute ''{0}'' on XML tag ''{1}''.", "v", "preference"));
                    }
                    result.put(k, v);
                }
            }
            return result;
        }
        catch (XPathException e) {
            throw new XmlParsingException(e);
        }
    }

    public OsmServerUserPreferencesReader() {
        this.setDoAuthenticate(true);
    }

    @Override
    public DataSet parseOsm(ProgressMonitor progressMonitor) throws OsmTransferException {
        return null;
    }

    public Map<String, String> fetchUserPreferences(ProgressMonitor monitor) throws OsmTransferException {
        return this.fetchUserPreferences(monitor, null);
    }

    public Map<String, String> fetchUserPreferences(ProgressMonitor monitor, String reason) throws OsmTransferException {
        return this.fetchData("user/preferences", I18n.tr("Reading user preferences ...", new Object[0]), OsmServerUserPreferencesReader::buildFromXML, monitor, reason);
    }
}

