/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.imagery;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.RowFilter;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableRowSorter;
import org.openstreetmap.josm.data.imagery.WMTSTileSource;
import org.openstreetmap.josm.gui.widgets.JosmTextArea;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class WMTSLayerSelection
extends JPanel {
    private final List<Map.Entry<String, List<WMTSTileSource.Layer>>> layers;
    private final JTable list;

    public WMTSLayerSelection(List<Map.Entry<String, List<WMTSTileSource.Layer>>> layers) {
        super(new GridBagLayout());
        this.layers = layers;
        this.list = new JTable(new AbstractTableModelExtension(layers));
        this.list.setSelectionMode(0);
        this.list.setAutoCreateRowSorter(true);
        this.list.setRowSelectionAllowed(true);
        this.list.setColumnSelectionAllowed(false);
        this.updateColumnPreferredWidth(this.list.getColumnModel().getColumn(0));
        this.updateColumnPreferredWidth(this.list.getColumnModel().getColumn(1));
        this.updateColumnPreferredWidth(this.list.getColumnModel().getColumn(2));
        this.add((Component)new JLabel(I18n.tr("Filter layers:", new Object[0])), GBC.eol().fill(2));
        final JosmTextArea filter = new JosmTextArea();
        filter.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.update();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.update();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.update();
            }

            private void update() {
                ((TableRowSorter)WMTSLayerSelection.this.list.getRowSorter()).setRowFilter(RowFilter.regexFilter("(?i)" + filter.getText(), new int[0]));
            }
        });
        this.add((Component)filter, GBC.eop().fill(2));
        this.add((Component)new JScrollPane(this.list), GBC.eol().fill());
    }

    public WMTSTileSource.Layer getSelectedLayer() {
        int index = this.list.getSelectedRow();
        if (index < 0) {
            return null;
        }
        return this.layers.get(this.list.convertRowIndexToModel(index)).getValue().get(0);
    }

    private void updateColumnPreferredWidth(TableColumn column) {
        TableCellRenderer renderer = column.getHeaderRenderer();
        if (renderer == null) {
            renderer = this.list.getTableHeader().getDefaultRenderer();
        }
        Component comp = renderer.getTableCellRendererComponent(this.list, column.getHeaderValue(), false, false, 0, 0);
        int ret = comp.getPreferredSize().width;
        for (int row = 0; row < this.list.getRowCount(); ++row) {
            renderer = this.list.getCellRenderer(row, column.getModelIndex());
            comp = this.list.prepareRenderer(renderer, row, column.getModelIndex());
            ret = Math.max(comp.getPreferredSize().width, ret);
        }
        column.setPreferredWidth(ret + 10);
    }

    public JTable getTable() {
        return this.list;
    }

    private static final class AbstractTableModelExtension
    extends AbstractTableModel {
        private final List<Map.Entry<String, List<WMTSTileSource.Layer>>> layers;

        private AbstractTableModelExtension(List<Map.Entry<String, List<WMTSTileSource.Layer>>> layers) {
            this.layers = layers;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return this.layers.get(rowIndex).getValue().stream().map(WMTSTileSource.Layer::getUserTitle).collect(Collectors.joining(", "));
                }
                case 1: {
                    return this.layers.get(rowIndex).getValue().stream().map(x -> x.getTileMatrixSet().getCrs()).collect(Collectors.joining(", "));
                }
                case 2: {
                    return this.layers.get(rowIndex).getValue().stream().map(x -> x.getTileMatrixSet().getIdentifier()).collect(Collectors.joining(", "));
                }
            }
            throw new IllegalArgumentException();
        }

        @Override
        public int getRowCount() {
            return this.layers.size();
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return I18n.tr("Layer name", new Object[0]);
                }
                case 1: {
                    return I18n.tr("Projection", new Object[0]);
                }
                case 2: {
                    return I18n.tr("Matrix set identifier", new Object[0]);
                }
            }
            throw new IllegalArgumentException();
        }
    }
}

