/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.downloadtasks;

import java.awt.Component;
import java.io.IOException;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.actions.downloadtasks.AbstractChangesetDownloadTask;
import org.openstreetmap.josm.data.UserIdentityManager;
import org.openstreetmap.josm.data.osm.UserInfo;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.io.ChangesetQuery;
import org.openstreetmap.josm.io.OsmServerUserInfoReader;
import org.openstreetmap.josm.io.OsmTransferCanceledException;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.ExceptionUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.xml.sax.SAXException;

public class ChangesetQueryTask
extends AbstractChangesetDownloadTask {
    public ChangesetQueryTask(ChangesetQuery query) {
        this(MainApplication.getMainFrame(), query);
    }

    public ChangesetQueryTask(Component parent, ChangesetQuery query) {
        CheckParameterUtil.ensureParameterNotNull(query, "query");
        this.setDownloadTask(new DownloadTask(parent, query));
    }

    class DownloadTask
    extends AbstractChangesetDownloadTask.RunnableDownloadTask {
        private ChangesetQuery query;
        private final OsmServerUserInfoReader userInfoReader;

        DownloadTask(Component parent, ChangesetQuery query) {
            super(parent, I18n.tr("Querying and downloading changesets", new Object[0]));
            this.userInfoReader = new OsmServerUserInfoReader();
            this.query = query;
        }

        protected void fullyIdentifyCurrentUser() throws OsmTransferException {
            this.getProgressMonitor().indeterminateSubTask(I18n.tr("Determine user id for current user...", new Object[0]));
            UserInfo info = this.userInfoReader.fetchUserInfo(this.getProgressMonitor().createSubTaskMonitor(1, false));
            UserIdentityManager im = UserIdentityManager.getInstance();
            im.setFullyIdentified(im.getUserName(), info);
        }

        @Override
        protected void realRun() throws SAXException, IOException, OsmTransferException {
            try {
                UserIdentityManager im = UserIdentityManager.getInstance();
                if (this.query.isRestrictedToPartiallyIdentifiedUser() && im.isCurrentUser(this.query.getUserName())) {
                    if (im.isPartiallyIdentified()) {
                        this.fullyIdentifyCurrentUser();
                    }
                    this.query = this.query.forUser(UserIdentityManager.getInstance().getUserId());
                }
                if (ChangesetQueryTask.this.isCanceled()) {
                    return;
                }
                this.getProgressMonitor().indeterminateSubTask(I18n.tr("Query and download changesets ...", new Object[0]));
                this.downloadedChangesets.addAll(this.reader.queryChangesets(this.query, this.getProgressMonitor().createSubTaskMonitor(0, false)));
            }
            catch (OsmTransferCanceledException e) {
                ChangesetQueryTask.this.setCanceled(true);
                Logging.trace(e);
            }
            catch (OsmTransferException e) {
                if (ChangesetQueryTask.this.isCanceled()) {
                    return;
                }
                this.rememberLastException(e);
            }
        }

        @Override
        protected void finish() {
            ChangesetQueryTask.this.rememberDownloadedData(this.downloadedChangesets);
            if (ChangesetQueryTask.this.isCanceled()) {
                return;
            }
            if (this.lastException != null) {
                GuiHelper.runInEDTAndWait(new Runnable(){
                    private final Component parent;
                    {
                        this.parent = DownloadTask.this.progressMonitor != null ? DownloadTask.this.progressMonitor.getWindowParent() : null;
                    }

                    @Override
                    public void run() {
                        JOptionPane.showMessageDialog(this.parent != null ? this.parent : MainApplication.getMainFrame(), ExceptionUtil.explainException(DownloadTask.this.lastException), I18n.tr("Errors during download", new Object[0]), 0);
                    }
                });
                return;
            }
            this.updateChangesets();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void cancel() {
            super.cancel();
            DownloadTask downloadTask = this;
            synchronized (downloadTask) {
                if (this.userInfoReader != null) {
                    this.userInfoReader.cancel();
                }
            }
        }
    }
}

