/*
 * Decompiled with CFR 0.152.
 */
package twitter4j.internal.json;

import java.io.Serializable;
import java.util.Date;
import twitter4j.RateLimitStatus;
import twitter4j.TwitterException;
import twitter4j.conf.Configuration;
import twitter4j.internal.http.HttpResponse;
import twitter4j.internal.json.DataObjectFactoryUtil;
import twitter4j.internal.org.json.JSONObject;
import twitter4j.internal.util.z_T4JInternalParseUtil;

final class RateLimitStatusJSONImpl
implements RateLimitStatus,
Serializable {
    private int remainingHits;
    private int hourlyLimit;
    private int resetTimeInSeconds;
    private int secondsUntilReset;
    private Date resetTime;
    private static final long serialVersionUID = 832355052293658614L;

    private RateLimitStatusJSONImpl(int hourlyLimit, int remainingHits, int resetTimeInSeconds, Date resetTime) {
        this.hourlyLimit = hourlyLimit;
        this.remainingHits = remainingHits;
        this.resetTime = resetTime;
        this.resetTimeInSeconds = resetTimeInSeconds;
        this.secondsUntilReset = (int)((resetTime.getTime() - System.currentTimeMillis()) / 1000L);
    }

    RateLimitStatusJSONImpl(HttpResponse res, Configuration conf) throws TwitterException {
        JSONObject json = res.asJSONObject();
        this.init(json);
        if (conf.isJSONStoreEnabled()) {
            DataObjectFactoryUtil.clearThreadLocalMap();
            DataObjectFactoryUtil.registerJSONObject(this, json);
        }
    }

    RateLimitStatusJSONImpl(JSONObject json) throws TwitterException {
        this.init(json);
    }

    void init(JSONObject json) throws TwitterException {
        this.hourlyLimit = z_T4JInternalParseUtil.getInt("hourly_limit", json);
        this.remainingHits = z_T4JInternalParseUtil.getInt("remaining_hits", json);
        this.resetTime = z_T4JInternalParseUtil.getDate("reset_time", json, "EEE MMM d HH:mm:ss Z yyyy");
        this.resetTimeInSeconds = z_T4JInternalParseUtil.getInt("reset_time_in_seconds", json);
        this.secondsUntilReset = (int)((this.resetTime.getTime() - System.currentTimeMillis()) / 1000L);
    }

    static RateLimitStatus createFromResponseHeader(HttpResponse res) {
        if (null == res) {
            return null;
        }
        String limit = res.getResponseHeader("X-RateLimit-Limit");
        if (limit == null) {
            return null;
        }
        int hourlyLimit = Integer.parseInt(limit);
        String remaining = res.getResponseHeader("X-RateLimit-Remaining");
        if (remaining == null) {
            return null;
        }
        int remainingHits = Integer.parseInt(remaining);
        String reset = res.getResponseHeader("X-RateLimit-Reset");
        if (reset == null) {
            return null;
        }
        long longReset = Long.parseLong(reset);
        int resetTimeInSeconds = (int)(longReset / 1000L);
        Date resetTime = new Date(longReset * 1000L);
        return new RateLimitStatusJSONImpl(hourlyLimit, remainingHits, resetTimeInSeconds, resetTime);
    }

    static RateLimitStatus createFeatureSpecificRateLimitStatusFromResponseHeader(HttpResponse res) {
        if (null == res) {
            return null;
        }
        String limit = res.getResponseHeader("X-FeatureRateLimit-Limit");
        if (limit == null) {
            return null;
        }
        int hourlyLimit = Integer.parseInt(limit);
        String remaining = res.getResponseHeader("X-FeatureRateLimit-Remaining");
        if (remaining == null) {
            return null;
        }
        int remainingHits = Integer.parseInt(remaining);
        String reset = res.getResponseHeader("X-FeatureRateLimit-Reset");
        if (reset == null) {
            return null;
        }
        long longReset = Long.parseLong(reset);
        int resetTimeInSeconds = (int)(longReset / 1000L);
        Date resetTime = new Date(longReset * 1000L);
        return new RateLimitStatusJSONImpl(hourlyLimit, remainingHits, resetTimeInSeconds, resetTime);
    }

    public int getRemainingHits() {
        return this.remainingHits;
    }

    public int getHourlyLimit() {
        return this.hourlyLimit;
    }

    public int getResetTimeInSeconds() {
        return this.resetTimeInSeconds;
    }

    public int getSecondsUntilReset() {
        return this.secondsUntilReset;
    }

    public Date getResetTime() {
        return this.resetTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RateLimitStatusJSONImpl)) {
            return false;
        }
        RateLimitStatusJSONImpl that = (RateLimitStatusJSONImpl)o;
        if (this.hourlyLimit != that.hourlyLimit) {
            return false;
        }
        if (this.remainingHits != that.remainingHits) {
            return false;
        }
        if (this.resetTimeInSeconds != that.resetTimeInSeconds) {
            return false;
        }
        if (this.secondsUntilReset != that.secondsUntilReset) {
            return false;
        }
        return !(this.resetTime != null ? !this.resetTime.equals(that.resetTime) : that.resetTime != null);
    }

    public int hashCode() {
        int result = this.remainingHits;
        result = 31 * result + this.hourlyLimit;
        result = 31 * result + this.resetTimeInSeconds;
        result = 31 * result + this.secondsUntilReset;
        result = 31 * result + (this.resetTime != null ? this.resetTime.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "RateLimitStatusJSONImpl{remainingHits=" + this.remainingHits + ", hourlyLimit=" + this.hourlyLimit + ", resetTimeInSeconds=" + this.resetTimeInSeconds + ", secondsUntilReset=" + this.secondsUntilReset + ", resetTime=" + this.resetTime + '}';
    }
}

