/*
 * Decompiled with CFR 0.152.
 */
package twitter4j.conf;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import twitter4j.Version;
import twitter4j.conf.Configuration;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ConfigurationBase
implements Configuration,
Serializable {
    private boolean debug;
    private String userAgent;
    private String user;
    private String password;
    private boolean useSSL;
    private boolean prettyDebug;
    private boolean gzipEnabled;
    private String httpProxyHost;
    private String httpProxyUser;
    private String httpProxyPassword;
    private int httpProxyPort;
    private int httpConnectionTimeout;
    private int httpReadTimeout;
    private int httpStreamingReadTimeout;
    private int httpRetryCount;
    private int httpRetryIntervalSeconds;
    private int maxTotalConnections;
    private int defaultMaxPerRoute;
    private String oAuthConsumerKey;
    private String oAuthConsumerSecret;
    private String oAuthAccessToken;
    private String oAuthAccessTokenSecret;
    private String oAuthRequestTokenURL;
    private String oAuthAuthorizationURL;
    private String oAuthAccessTokenURL;
    private String oAuthAuthenticationURL;
    private String restBaseURL;
    private String searchBaseURL;
    private String streamBaseURL;
    private String userStreamBaseURL;
    private String siteStreamBaseURL;
    private String uploadBaseURL;
    private String dispatcherImpl;
    private int asyncNumThreads;
    private boolean includeRTsEnabled;
    private boolean includeEntitiesEnabled;
    private boolean jsonStoreEnabled;
    private boolean mbeanEnabled;
    private boolean userStreamRepliesAllEnabled;
    private String mediaProvider;
    private String mediaProviderAPIKey;
    private Properties mediaProviderParameters;
    private String clientVersion;
    private String clientURL;
    public static final String DALVIK = "twitter4j.dalvik";
    public static final String GAE = "twitter4j.gae";
    private static final String DEFAULT_OAUTH_REQUEST_TOKEN_URL = "http://api.twitter.com/oauth/request_token";
    private static final String DEFAULT_OAUTH_AUTHORIZATION_URL = "http://api.twitter.com/oauth/authorize";
    private static final String DEFAULT_OAUTH_ACCESS_TOKEN_URL = "http://api.twitter.com/oauth/access_token";
    private static final String DEFAULT_OAUTH_AUTHENTICATION_URL = "http://api.twitter.com/oauth/authenticate";
    private static final String DEFAULT_REST_BASE_URL = "http://api.twitter.com/1/";
    private static final String DEFAULT_SEARCH_BASE_URL = "http://search.twitter.com/";
    private static final String DEFAULT_STREAM_BASE_URL = "https://stream.twitter.com/1/";
    private static final String DEFAULT_USER_STREAM_BASE_URL = "https://userstream.twitter.com/2/";
    private static final String DEFAULT_SITE_STREAM_BASE_URL = "https://sitestream.twitter.com/2b/";
    private static final String DEFAULT_UPLOAD_BASE_URL = "http://upload.twitter.com/1/";
    private boolean IS_DALVIK;
    private boolean IS_GAE;
    private static final long serialVersionUID = -6610497517837844232L;
    static String dalvikDetected;
    static String gaeDetected;
    Map<String, String> requestHeaders;
    private static final List<ConfigurationBase> instances;

    protected ConfigurationBase() {
        String isGAE;
        String isDalvik;
        this.setDebug(false);
        this.setUser(null);
        this.setPassword(null);
        this.setUseSSL(false);
        this.setPrettyDebugEnabled(false);
        this.setGZIPEnabled(true);
        this.setHttpProxyHost(null);
        this.setHttpProxyUser(null);
        this.setHttpProxyPassword(null);
        this.setHttpProxyPort(-1);
        this.setHttpConnectionTimeout(20000);
        this.setHttpReadTimeout(120000);
        this.setHttpStreamingReadTimeout(40000);
        this.setHttpRetryCount(0);
        this.setHttpRetryIntervalSeconds(5);
        this.setHttpMaxTotalConnections(20);
        this.setHttpDefaultMaxPerRoute(2);
        this.setOAuthConsumerKey(null);
        this.setOAuthConsumerSecret(null);
        this.setOAuthAccessToken(null);
        this.setOAuthAccessTokenSecret(null);
        this.setAsyncNumThreads(1);
        this.setClientVersion(Version.getVersion());
        this.setClientURL(new StringBuffer().append("http://twitter4j.org/en/twitter4j-").append(Version.getVersion()).append(".xml").toString());
        this.setUserAgent(new StringBuffer().append("twitter4j http://twitter4j.org/ /").append(Version.getVersion()).toString());
        this.setIncludeRTsEnbled(true);
        this.setIncludeEntitiesEnbled(true);
        this.setJSONStoreEnabled(false);
        this.setMBeanEnabled(false);
        this.setOAuthRequestTokenURL(DEFAULT_OAUTH_REQUEST_TOKEN_URL);
        this.setOAuthAuthorizationURL(DEFAULT_OAUTH_AUTHORIZATION_URL);
        this.setOAuthAccessTokenURL(DEFAULT_OAUTH_ACCESS_TOKEN_URL);
        this.setOAuthAuthenticationURL(DEFAULT_OAUTH_AUTHENTICATION_URL);
        this.setRestBaseURL(DEFAULT_REST_BASE_URL);
        this.setSearchBaseURL(DEFAULT_SEARCH_BASE_URL);
        this.setStreamBaseURL(DEFAULT_STREAM_BASE_URL);
        this.setUserStreamBaseURL(DEFAULT_USER_STREAM_BASE_URL);
        this.setSiteStreamBaseURL(DEFAULT_SITE_STREAM_BASE_URL);
        this.setUploadBaseURL(DEFAULT_UPLOAD_BASE_URL);
        this.setDispatcherImpl("twitter4j.internal.async.DispatcherImpl");
        this.setIncludeRTsEnbled(true);
        this.setUserStreamRepliesAllEnabled(true);
        try {
            isDalvik = System.getProperty(DALVIK, dalvikDetected);
        }
        catch (SecurityException ignore) {
            isDalvik = dalvikDetected;
        }
        this.IS_DALVIK = Boolean.valueOf(isDalvik);
        try {
            isGAE = System.getProperty(GAE, gaeDetected);
        }
        catch (SecurityException ignore) {
            isGAE = gaeDetected;
        }
        this.IS_GAE = Boolean.valueOf(isGAE);
        this.setMediaProvider("TWITTER");
        this.setMediaProviderAPIKey(null);
        this.setMediaProviderParameters(null);
    }

    @Override
    public final boolean isDalvik() {
        return this.IS_DALVIK;
    }

    @Override
    public boolean isGAE() {
        return this.IS_GAE;
    }

    @Override
    public final boolean isDebugEnabled() {
        return this.debug;
    }

    protected final void setDebug(boolean debug) {
        this.debug = debug;
    }

    @Override
    public final String getUserAgent() {
        return this.userAgent;
    }

    protected final void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
        this.initRequestHeaders();
    }

    @Override
    public final String getUser() {
        return this.user;
    }

    protected final void setUser(String user) {
        this.user = user;
    }

    @Override
    public final String getPassword() {
        return this.password;
    }

    protected final void setPassword(String password) {
        this.password = password;
    }

    @Override
    public boolean isPrettyDebugEnabled() {
        return this.prettyDebug;
    }

    protected final void setUseSSL(boolean useSSL) {
        this.useSSL = useSSL;
        this.fixRestBaseURL();
    }

    protected final void setPrettyDebugEnabled(boolean prettyDebug) {
        this.prettyDebug = prettyDebug;
    }

    protected final void setGZIPEnabled(boolean gzipEnabled) {
        this.gzipEnabled = gzipEnabled;
        this.initRequestHeaders();
    }

    @Override
    public boolean isGZIPEnabled() {
        return this.gzipEnabled;
    }

    private void initRequestHeaders() {
        this.requestHeaders = new HashMap<String, String>();
        this.requestHeaders.put("X-Twitter-Client-Version", this.getClientVersion());
        this.requestHeaders.put("X-Twitter-Client-URL", this.getClientURL());
        this.requestHeaders.put("X-Twitter-Client", "Twitter4J");
        this.requestHeaders.put("User-Agent", this.getUserAgent());
        if (this.gzipEnabled) {
            this.requestHeaders.put("Accept-Encoding", "gzip");
        }
        if (this.IS_DALVIK) {
            this.requestHeaders.put("Connection", "close");
        }
    }

    @Override
    public Map<String, String> getRequestHeaders() {
        return this.requestHeaders;
    }

    @Override
    public final String getHttpProxyHost() {
        return this.httpProxyHost;
    }

    protected final void setHttpProxyHost(String proxyHost) {
        this.httpProxyHost = proxyHost;
    }

    @Override
    public final String getHttpProxyUser() {
        return this.httpProxyUser;
    }

    protected final void setHttpProxyUser(String proxyUser) {
        this.httpProxyUser = proxyUser;
    }

    @Override
    public final String getHttpProxyPassword() {
        return this.httpProxyPassword;
    }

    protected final void setHttpProxyPassword(String proxyPassword) {
        this.httpProxyPassword = proxyPassword;
    }

    @Override
    public final int getHttpProxyPort() {
        return this.httpProxyPort;
    }

    protected final void setHttpProxyPort(int proxyPort) {
        this.httpProxyPort = proxyPort;
    }

    @Override
    public final int getHttpConnectionTimeout() {
        return this.httpConnectionTimeout;
    }

    protected final void setHttpConnectionTimeout(int connectionTimeout) {
        this.httpConnectionTimeout = connectionTimeout;
    }

    @Override
    public final int getHttpReadTimeout() {
        return this.httpReadTimeout;
    }

    protected final void setHttpReadTimeout(int readTimeout) {
        this.httpReadTimeout = readTimeout;
    }

    @Override
    public int getHttpStreamingReadTimeout() {
        return this.httpStreamingReadTimeout;
    }

    protected final void setHttpStreamingReadTimeout(int httpStreamingReadTimeout) {
        this.httpStreamingReadTimeout = httpStreamingReadTimeout;
    }

    @Override
    public final int getHttpRetryCount() {
        return this.httpRetryCount;
    }

    protected final void setHttpRetryCount(int retryCount) {
        this.httpRetryCount = retryCount;
    }

    @Override
    public final int getHttpRetryIntervalSeconds() {
        return this.httpRetryIntervalSeconds;
    }

    protected final void setHttpRetryIntervalSeconds(int retryIntervalSeconds) {
        this.httpRetryIntervalSeconds = retryIntervalSeconds;
    }

    @Override
    public final int getHttpMaxTotalConnections() {
        return this.maxTotalConnections;
    }

    protected final void setHttpMaxTotalConnections(int maxTotalConnections) {
        this.maxTotalConnections = maxTotalConnections;
    }

    @Override
    public final int getHttpDefaultMaxPerRoute() {
        return this.defaultMaxPerRoute;
    }

    protected final void setHttpDefaultMaxPerRoute(int defaultMaxPerRoute) {
        this.defaultMaxPerRoute = defaultMaxPerRoute;
    }

    @Override
    public final String getOAuthConsumerKey() {
        return this.oAuthConsumerKey;
    }

    protected final void setOAuthConsumerKey(String oAuthConsumerKey) {
        this.oAuthConsumerKey = oAuthConsumerKey;
        this.fixRestBaseURL();
    }

    @Override
    public final String getOAuthConsumerSecret() {
        return this.oAuthConsumerSecret;
    }

    protected final void setOAuthConsumerSecret(String oAuthConsumerSecret) {
        this.oAuthConsumerSecret = oAuthConsumerSecret;
        this.fixRestBaseURL();
    }

    @Override
    public String getOAuthAccessToken() {
        return this.oAuthAccessToken;
    }

    protected final void setOAuthAccessToken(String oAuthAccessToken) {
        this.oAuthAccessToken = oAuthAccessToken;
    }

    @Override
    public String getOAuthAccessTokenSecret() {
        return this.oAuthAccessTokenSecret;
    }

    protected final void setOAuthAccessTokenSecret(String oAuthAccessTokenSecret) {
        this.oAuthAccessTokenSecret = oAuthAccessTokenSecret;
    }

    @Override
    public final int getAsyncNumThreads() {
        return this.asyncNumThreads;
    }

    protected final void setAsyncNumThreads(int asyncNumThreads) {
        this.asyncNumThreads = asyncNumThreads;
    }

    @Override
    public final String getClientVersion() {
        return this.clientVersion;
    }

    protected final void setClientVersion(String clientVersion) {
        this.clientVersion = clientVersion;
        this.initRequestHeaders();
    }

    @Override
    public final String getClientURL() {
        return this.clientURL;
    }

    protected final void setClientURL(String clientURL) {
        this.clientURL = clientURL;
        this.initRequestHeaders();
    }

    @Override
    public String getRestBaseURL() {
        return this.restBaseURL;
    }

    protected final void setRestBaseURL(String restBaseURL) {
        this.restBaseURL = restBaseURL;
        this.fixRestBaseURL();
    }

    private void fixRestBaseURL() {
        if (DEFAULT_REST_BASE_URL.equals(ConfigurationBase.fixURL(false, this.restBaseURL))) {
            this.restBaseURL = ConfigurationBase.fixURL(this.useSSL, this.restBaseURL);
        }
        if (DEFAULT_OAUTH_ACCESS_TOKEN_URL.equals(ConfigurationBase.fixURL(false, this.oAuthAccessTokenURL))) {
            this.oAuthAccessTokenURL = ConfigurationBase.fixURL(this.useSSL, this.oAuthAccessTokenURL);
        }
        if (DEFAULT_OAUTH_AUTHENTICATION_URL.equals(ConfigurationBase.fixURL(false, this.oAuthAuthenticationURL))) {
            this.oAuthAuthenticationURL = ConfigurationBase.fixURL(this.useSSL, this.oAuthAuthenticationURL);
        }
        if (DEFAULT_OAUTH_AUTHORIZATION_URL.equals(ConfigurationBase.fixURL(false, this.oAuthAuthorizationURL))) {
            this.oAuthAuthorizationURL = ConfigurationBase.fixURL(this.useSSL, this.oAuthAuthorizationURL);
        }
        if (DEFAULT_OAUTH_REQUEST_TOKEN_URL.equals(ConfigurationBase.fixURL(false, this.oAuthRequestTokenURL))) {
            this.oAuthRequestTokenURL = ConfigurationBase.fixURL(this.useSSL, this.oAuthRequestTokenURL);
        }
        if (DEFAULT_SEARCH_BASE_URL.equals(ConfigurationBase.fixURL(false, this.searchBaseURL))) {
            this.searchBaseURL = ConfigurationBase.fixURL(this.useSSL, this.searchBaseURL);
        }
    }

    @Override
    public String getSearchBaseURL() {
        return this.searchBaseURL;
    }

    protected final void setSearchBaseURL(String searchBaseURL) {
        this.searchBaseURL = searchBaseURL;
    }

    @Override
    public String getStreamBaseURL() {
        return this.streamBaseURL;
    }

    protected final void setStreamBaseURL(String streamBaseURL) {
        this.streamBaseURL = streamBaseURL;
    }

    @Override
    public String getUserStreamBaseURL() {
        return this.userStreamBaseURL;
    }

    protected final void setUserStreamBaseURL(String siteStreamBaseURL) {
        this.userStreamBaseURL = siteStreamBaseURL;
    }

    @Override
    public String getSiteStreamBaseURL() {
        return this.siteStreamBaseURL;
    }

    protected final void setSiteStreamBaseURL(String siteStreamBaseURL) {
        this.siteStreamBaseURL = siteStreamBaseURL;
    }

    @Override
    public String getUploadBaseURL() {
        return this.uploadBaseURL;
    }

    protected final void setUploadBaseURL(String uploadBaseURL) {
        this.uploadBaseURL = uploadBaseURL;
        this.fixUploadBaseURL();
    }

    private void fixUploadBaseURL() {
        if (DEFAULT_UPLOAD_BASE_URL.equals(ConfigurationBase.fixURL(false, this.uploadBaseURL))) {
            this.uploadBaseURL = ConfigurationBase.fixURL(this.useSSL, this.uploadBaseURL);
        }
    }

    @Override
    public String getOAuthRequestTokenURL() {
        return this.oAuthRequestTokenURL;
    }

    protected final void setOAuthRequestTokenURL(String oAuthRequestTokenURL) {
        this.oAuthRequestTokenURL = oAuthRequestTokenURL;
        this.fixRestBaseURL();
    }

    @Override
    public String getOAuthAuthorizationURL() {
        return this.oAuthAuthorizationURL;
    }

    protected final void setOAuthAuthorizationURL(String oAuthAuthorizationURL) {
        this.oAuthAuthorizationURL = oAuthAuthorizationURL;
        this.fixRestBaseURL();
    }

    @Override
    public String getOAuthAccessTokenURL() {
        return this.oAuthAccessTokenURL;
    }

    protected final void setOAuthAccessTokenURL(String oAuthAccessTokenURL) {
        this.oAuthAccessTokenURL = oAuthAccessTokenURL;
        this.fixRestBaseURL();
    }

    @Override
    public String getOAuthAuthenticationURL() {
        return this.oAuthAuthenticationURL;
    }

    protected final void setOAuthAuthenticationURL(String oAuthAuthenticationURL) {
        this.oAuthAuthenticationURL = oAuthAuthenticationURL;
        this.fixRestBaseURL();
    }

    @Override
    public String getDispatcherImpl() {
        return this.dispatcherImpl;
    }

    protected final void setDispatcherImpl(String dispatcherImpl) {
        this.dispatcherImpl = dispatcherImpl;
    }

    @Override
    public boolean isIncludeRTsEnabled() {
        return this.includeRTsEnabled;
    }

    protected final void setIncludeRTsEnbled(boolean enabled) {
        this.includeRTsEnabled = enabled;
    }

    @Override
    public boolean isIncludeEntitiesEnabled() {
        return this.includeEntitiesEnabled;
    }

    protected final void setIncludeEntitiesEnbled(boolean enabled) {
        this.includeEntitiesEnabled = enabled;
    }

    @Override
    public boolean isJSONStoreEnabled() {
        return this.jsonStoreEnabled;
    }

    protected final void setJSONStoreEnabled(boolean enabled) {
        this.jsonStoreEnabled = enabled;
    }

    @Override
    public boolean isMBeanEnabled() {
        return this.mbeanEnabled;
    }

    protected final void setMBeanEnabled(boolean enabled) {
        this.mbeanEnabled = enabled;
    }

    @Override
    public boolean isUserStreamRepliesAllEnabled() {
        return this.userStreamRepliesAllEnabled;
    }

    protected final void setUserStreamRepliesAllEnabled(boolean enabled) {
        this.userStreamRepliesAllEnabled = enabled;
    }

    @Override
    public String getMediaProvider() {
        return this.mediaProvider;
    }

    protected final void setMediaProvider(String mediaProvider) {
        this.mediaProvider = mediaProvider;
    }

    @Override
    public String getMediaProviderAPIKey() {
        return this.mediaProviderAPIKey;
    }

    protected final void setMediaProviderAPIKey(String mediaProviderAPIKey) {
        this.mediaProviderAPIKey = mediaProviderAPIKey;
    }

    @Override
    public Properties getMediaProviderParameters() {
        return this.mediaProviderParameters;
    }

    protected final void setMediaProviderParameters(Properties props) {
        this.mediaProviderParameters = props;
    }

    static String fixURL(boolean useSSL, String url) {
        if (null == url) {
            return null;
        }
        int index = url.indexOf("://");
        if (-1 == index) {
            throw new IllegalArgumentException("url should contain '://'");
        }
        String hostAndLater = url.substring(index + 3);
        if (useSSL) {
            return new StringBuffer().append("https://").append(hostAndLater).toString();
        }
        return new StringBuffer().append("http://").append(hostAndLater).toString();
    }

    public int hashCode() {
        int result = this.debug ? 1 : 0;
        result = 31 * result + (this.userAgent != null ? this.userAgent.hashCode() : 0);
        result = 31 * result + (this.user != null ? this.user.hashCode() : 0);
        result = 31 * result + (this.password != null ? this.password.hashCode() : 0);
        result = 31 * result + (this.useSSL ? 1 : 0);
        result = 31 * result + (this.prettyDebug ? 1 : 0);
        result = 31 * result + (this.gzipEnabled ? 1 : 0);
        result = 31 * result + (this.httpProxyHost != null ? this.httpProxyHost.hashCode() : 0);
        result = 31 * result + (this.httpProxyUser != null ? this.httpProxyUser.hashCode() : 0);
        result = 31 * result + (this.httpProxyPassword != null ? this.httpProxyPassword.hashCode() : 0);
        result = 31 * result + this.httpProxyPort;
        result = 31 * result + this.httpConnectionTimeout;
        result = 31 * result + this.httpReadTimeout;
        result = 31 * result + this.httpStreamingReadTimeout;
        result = 31 * result + this.httpRetryCount;
        result = 31 * result + this.httpRetryIntervalSeconds;
        result = 31 * result + this.maxTotalConnections;
        result = 31 * result + this.defaultMaxPerRoute;
        result = 31 * result + (this.oAuthConsumerKey != null ? this.oAuthConsumerKey.hashCode() : 0);
        result = 31 * result + (this.oAuthConsumerSecret != null ? this.oAuthConsumerSecret.hashCode() : 0);
        result = 31 * result + (this.oAuthAccessToken != null ? this.oAuthAccessToken.hashCode() : 0);
        result = 31 * result + (this.oAuthAccessTokenSecret != null ? this.oAuthAccessTokenSecret.hashCode() : 0);
        result = 31 * result + (this.oAuthRequestTokenURL != null ? this.oAuthRequestTokenURL.hashCode() : 0);
        result = 31 * result + (this.oAuthAuthorizationURL != null ? this.oAuthAuthorizationURL.hashCode() : 0);
        result = 31 * result + (this.oAuthAccessTokenURL != null ? this.oAuthAccessTokenURL.hashCode() : 0);
        result = 31 * result + (this.oAuthAuthenticationURL != null ? this.oAuthAuthenticationURL.hashCode() : 0);
        result = 31 * result + (this.restBaseURL != null ? this.restBaseURL.hashCode() : 0);
        result = 31 * result + (this.searchBaseURL != null ? this.searchBaseURL.hashCode() : 0);
        result = 31 * result + (this.streamBaseURL != null ? this.streamBaseURL.hashCode() : 0);
        result = 31 * result + (this.userStreamBaseURL != null ? this.userStreamBaseURL.hashCode() : 0);
        result = 31 * result + (this.siteStreamBaseURL != null ? this.siteStreamBaseURL.hashCode() : 0);
        result = 31 * result + (this.uploadBaseURL != null ? this.uploadBaseURL.hashCode() : 0);
        result = 31 * result + (this.dispatcherImpl != null ? this.dispatcherImpl.hashCode() : 0);
        result = 31 * result + this.asyncNumThreads;
        result = 31 * result + (this.includeRTsEnabled ? 1 : 0);
        result = 31 * result + (this.includeEntitiesEnabled ? 1 : 0);
        result = 31 * result + (this.jsonStoreEnabled ? 1 : 0);
        result = 31 * result + (this.mbeanEnabled ? 1 : 0);
        result = 31 * result + (this.userStreamRepliesAllEnabled ? 1 : 0);
        result = 31 * result + (this.mediaProvider != null ? this.mediaProvider.hashCode() : 0);
        result = 31 * result + (this.mediaProviderAPIKey != null ? this.mediaProviderAPIKey.hashCode() : 0);
        result = 31 * result + (this.mediaProviderParameters != null ? this.mediaProviderParameters.hashCode() : 0);
        result = 31 * result + (this.clientVersion != null ? this.clientVersion.hashCode() : 0);
        result = 31 * result + (this.clientURL != null ? this.clientURL.hashCode() : 0);
        result = 31 * result + (this.IS_DALVIK ? 1 : 0);
        result = 31 * result + (this.IS_GAE ? 1 : 0);
        result = 31 * result + (this.requestHeaders != null ? ((Object)this.requestHeaders).hashCode() : 0);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConfigurationBase)) {
            return false;
        }
        ConfigurationBase that = (ConfigurationBase)o;
        if (this.asyncNumThreads != that.asyncNumThreads) {
            return false;
        }
        if (this.debug != that.debug) {
            return false;
        }
        if (this.defaultMaxPerRoute != that.defaultMaxPerRoute) {
            return false;
        }
        if (this.gzipEnabled != that.gzipEnabled) {
            return false;
        }
        if (this.httpConnectionTimeout != that.httpConnectionTimeout) {
            return false;
        }
        if (this.httpProxyPort != that.httpProxyPort) {
            return false;
        }
        if (this.httpReadTimeout != that.httpReadTimeout) {
            return false;
        }
        if (this.httpRetryCount != that.httpRetryCount) {
            return false;
        }
        if (this.httpRetryIntervalSeconds != that.httpRetryIntervalSeconds) {
            return false;
        }
        if (this.httpStreamingReadTimeout != that.httpStreamingReadTimeout) {
            return false;
        }
        if (this.includeEntitiesEnabled != that.includeEntitiesEnabled) {
            return false;
        }
        if (this.includeRTsEnabled != that.includeRTsEnabled) {
            return false;
        }
        if (this.jsonStoreEnabled != that.jsonStoreEnabled) {
            return false;
        }
        if (this.maxTotalConnections != that.maxTotalConnections) {
            return false;
        }
        if (this.mbeanEnabled != that.mbeanEnabled) {
            return false;
        }
        if (this.prettyDebug != that.prettyDebug) {
            return false;
        }
        if (this.useSSL != that.useSSL) {
            return false;
        }
        if (this.userStreamRepliesAllEnabled != that.userStreamRepliesAllEnabled) {
            return false;
        }
        if (this.clientURL != null ? !this.clientURL.equals(that.clientURL) : that.clientURL != null) {
            return false;
        }
        if (this.clientVersion != null ? !this.clientVersion.equals(that.clientVersion) : that.clientVersion != null) {
            return false;
        }
        if (this.dispatcherImpl != null ? !this.dispatcherImpl.equals(that.dispatcherImpl) : that.dispatcherImpl != null) {
            return false;
        }
        if (this.httpProxyHost != null ? !this.httpProxyHost.equals(that.httpProxyHost) : that.httpProxyHost != null) {
            return false;
        }
        if (this.httpProxyPassword != null ? !this.httpProxyPassword.equals(that.httpProxyPassword) : that.httpProxyPassword != null) {
            return false;
        }
        if (this.httpProxyUser != null ? !this.httpProxyUser.equals(that.httpProxyUser) : that.httpProxyUser != null) {
            return false;
        }
        if (this.mediaProvider != null ? !this.mediaProvider.equals(that.mediaProvider) : that.mediaProvider != null) {
            return false;
        }
        if (this.mediaProviderAPIKey != null ? !this.mediaProviderAPIKey.equals(that.mediaProviderAPIKey) : that.mediaProviderAPIKey != null) {
            return false;
        }
        if (this.mediaProviderParameters != null ? !this.mediaProviderParameters.equals(that.mediaProviderParameters) : that.mediaProviderParameters != null) {
            return false;
        }
        if (this.oAuthAccessToken != null ? !this.oAuthAccessToken.equals(that.oAuthAccessToken) : that.oAuthAccessToken != null) {
            return false;
        }
        if (this.oAuthAccessTokenSecret != null ? !this.oAuthAccessTokenSecret.equals(that.oAuthAccessTokenSecret) : that.oAuthAccessTokenSecret != null) {
            return false;
        }
        if (this.oAuthAccessTokenURL != null ? !this.oAuthAccessTokenURL.equals(that.oAuthAccessTokenURL) : that.oAuthAccessTokenURL != null) {
            return false;
        }
        if (this.oAuthAuthenticationURL != null ? !this.oAuthAuthenticationURL.equals(that.oAuthAuthenticationURL) : that.oAuthAuthenticationURL != null) {
            return false;
        }
        if (this.oAuthAuthorizationURL != null ? !this.oAuthAuthorizationURL.equals(that.oAuthAuthorizationURL) : that.oAuthAuthorizationURL != null) {
            return false;
        }
        if (this.oAuthConsumerKey != null ? !this.oAuthConsumerKey.equals(that.oAuthConsumerKey) : that.oAuthConsumerKey != null) {
            return false;
        }
        if (this.oAuthConsumerSecret != null ? !this.oAuthConsumerSecret.equals(that.oAuthConsumerSecret) : that.oAuthConsumerSecret != null) {
            return false;
        }
        if (this.oAuthRequestTokenURL != null ? !this.oAuthRequestTokenURL.equals(that.oAuthRequestTokenURL) : that.oAuthRequestTokenURL != null) {
            return false;
        }
        if (this.password != null ? !this.password.equals(that.password) : that.password != null) {
            return false;
        }
        if (this.requestHeaders != null ? !((Object)this.requestHeaders).equals(that.requestHeaders) : that.requestHeaders != null) {
            return false;
        }
        if (this.restBaseURL != null ? !this.restBaseURL.equals(that.restBaseURL) : that.restBaseURL != null) {
            return false;
        }
        if (this.searchBaseURL != null ? !this.searchBaseURL.equals(that.searchBaseURL) : that.searchBaseURL != null) {
            return false;
        }
        if (this.siteStreamBaseURL != null ? !this.siteStreamBaseURL.equals(that.siteStreamBaseURL) : that.siteStreamBaseURL != null) {
            return false;
        }
        if (this.streamBaseURL != null ? !this.streamBaseURL.equals(that.streamBaseURL) : that.streamBaseURL != null) {
            return false;
        }
        if (this.uploadBaseURL != null ? !this.uploadBaseURL.equals(that.uploadBaseURL) : that.uploadBaseURL != null) {
            return false;
        }
        if (this.user != null ? !this.user.equals(that.user) : that.user != null) {
            return false;
        }
        if (this.userAgent != null ? !this.userAgent.equals(that.userAgent) : that.userAgent != null) {
            return false;
        }
        return !(this.userStreamBaseURL != null ? !this.userStreamBaseURL.equals(that.userStreamBaseURL) : that.userStreamBaseURL != null);
    }

    public String toString() {
        return new StringBuffer().append("ConfigurationBase{debug=").append(this.debug).append(", userAgent='").append(this.userAgent).append('\'').append(", user='").append(this.user).append('\'').append(", password='").append(this.password).append('\'').append(", useSSL=").append(this.useSSL).append(", prettyDebug=").append(this.prettyDebug).append(", gzipEnabled=").append(this.gzipEnabled).append(", httpProxyHost='").append(this.httpProxyHost).append('\'').append(", httpProxyUser='").append(this.httpProxyUser).append('\'').append(", httpProxyPassword='").append(this.httpProxyPassword).append('\'').append(", httpProxyPort=").append(this.httpProxyPort).append(", httpConnectionTimeout=").append(this.httpConnectionTimeout).append(", httpReadTimeout=").append(this.httpReadTimeout).append(", httpStreamingReadTimeout=").append(this.httpStreamingReadTimeout).append(", httpRetryCount=").append(this.httpRetryCount).append(", httpRetryIntervalSeconds=").append(this.httpRetryIntervalSeconds).append(", maxTotalConnections=").append(this.maxTotalConnections).append(", defaultMaxPerRoute=").append(this.defaultMaxPerRoute).append(", oAuthConsumerKey='").append(this.oAuthConsumerKey).append('\'').append(", oAuthConsumerSecret='").append(this.oAuthConsumerSecret).append('\'').append(", oAuthAccessToken='").append(this.oAuthAccessToken).append('\'').append(", oAuthAccessTokenSecret='").append(this.oAuthAccessTokenSecret).append('\'').append(", oAuthRequestTokenURL='").append(this.oAuthRequestTokenURL).append('\'').append(", oAuthAuthorizationURL='").append(this.oAuthAuthorizationURL).append('\'').append(", oAuthAccessTokenURL='").append(this.oAuthAccessTokenURL).append('\'').append(", oAuthAuthenticationURL='").append(this.oAuthAuthenticationURL).append('\'').append(", restBaseURL='").append(this.restBaseURL).append('\'').append(", searchBaseURL='").append(this.searchBaseURL).append('\'').append(", streamBaseURL='").append(this.streamBaseURL).append('\'').append(", userStreamBaseURL='").append(this.userStreamBaseURL).append('\'').append(", siteStreamBaseURL='").append(this.siteStreamBaseURL).append('\'').append(", uploadBaseURL='").append(this.uploadBaseURL).append('\'').append(", dispatcherImpl='").append(this.dispatcherImpl).append('\'').append(", asyncNumThreads=").append(this.asyncNumThreads).append(", includeRTsEnabled=").append(this.includeRTsEnabled).append(", includeEntitiesEnabled=").append(this.includeEntitiesEnabled).append(", jsonStoreEnabled=").append(this.jsonStoreEnabled).append(", mbeanEnabled=").append(this.mbeanEnabled).append(", userStreamRepliesAllEnabled=").append(this.userStreamRepliesAllEnabled).append(", mediaProvider='").append(this.mediaProvider).append('\'').append(", mediaProviderAPIKey='").append(this.mediaProviderAPIKey).append('\'').append(", mediaProviderParameters=").append(this.mediaProviderParameters).append(", clientVersion='").append(this.clientVersion).append('\'').append(", clientURL='").append(this.clientURL).append('\'').append(", IS_DALVIK=").append(this.IS_DALVIK).append(", IS_GAE=").append(this.IS_GAE).append(", requestHeaders=").append(this.requestHeaders).append('}').toString();
    }

    private static void cacheInstance(ConfigurationBase conf) {
        if (!instances.contains(conf)) {
            instances.add(conf);
        }
    }

    protected void cacheInstance() {
        ConfigurationBase.cacheInstance(this);
    }

    private static ConfigurationBase getInstance(ConfigurationBase configurationBase) {
        int index = instances.indexOf(configurationBase);
        if (index == -1) {
            instances.add(configurationBase);
            return configurationBase;
        }
        return instances.get(index);
    }

    protected Object readResolve() throws ObjectStreamException {
        return ConfigurationBase.getInstance(this);
    }

    static {
        try {
            Class.forName("dalvik.system.VMRuntime");
            dalvikDetected = "true";
        }
        catch (ClassNotFoundException cnfe) {
            dalvikDetected = "false";
        }
        try {
            Class.forName("com.google.appengine.api.urlfetch.URLFetchService");
            gaeDetected = "true";
        }
        catch (ClassNotFoundException cnfe) {
            gaeDetected = "false";
        }
        instances = new ArrayList<ConfigurationBase>();
    }
}

