/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.comp;

import com.sun.source.tree.LambdaExpressionTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.Attr;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.Check;
import com.sun.tools.javac.comp.DeferredAttr;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.comp.Infer;
import com.sun.tools.javac.comp.Resolve;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeCopier;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.DiagnosticSource;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;

public class ArgumentAttr
extends JCTree.Visitor {
    protected static final Context.Key<ArgumentAttr> methodAttrKey = new Context.Key();
    private final DeferredAttr deferredAttr;
    private final Attr attr;
    private final Symtab syms;
    private final Log log;
    private Env<AttrContext> env;
    private Type result;
    Map<UniquePos, ArgumentType<?>> argumentTypeCache = new LinkedHashMap();

    public static ArgumentAttr instance(Context context) {
        ArgumentAttr argumentAttr = context.get(methodAttrKey);
        if (argumentAttr == null) {
            argumentAttr = new ArgumentAttr(context);
        }
        return argumentAttr;
    }

    protected ArgumentAttr(Context context) {
        context.put(methodAttrKey, this);
        this.deferredAttr = DeferredAttr.instance(context);
        this.attr = Attr.instance(context);
        this.syms = Symtab.instance(context);
        this.log = Log.instance(context);
    }

    void setResult(JCTree.JCExpression jCExpression, Type type) {
        this.result = type;
        if (((AttrContext)this.env.info).isSpeculative) {
            jCExpression.type = this.result;
        }
    }

    Type checkSpeculative(JCTree.JCExpression jCExpression, Attr.ResultInfo resultInfo) {
        return this.checkSpeculative(jCExpression, jCExpression.type, resultInfo);
    }

    Type checkSpeculative(JCDiagnostic.DiagnosticPosition diagnosticPosition, Type type, Attr.ResultInfo resultInfo) {
        if (type.hasTag(TypeTag.DEFERRED)) {
            return ((DeferredAttr.DeferredType)type).check(resultInfo);
        }
        return resultInfo.check(diagnosticPosition, type);
    }

    LocalCacheContext withLocalCacheContext() {
        return new LocalCacheContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Type attribArg(JCTree jCTree, Env<AttrContext> env) {
        Env<AttrContext> env2 = this.env;
        try {
            this.env = env;
            jCTree.accept(this);
            Type type = this.result;
            return type;
        }
        finally {
            this.env = env2;
        }
    }

    @Override
    public void visitTree(JCTree jCTree) {
        jCTree.accept(this.attr);
        this.result = this.attr.result;
    }

    <T extends JCTree.JCExpression, Z extends ArgumentType<T>> void processArg(T t, Function<T, Z> function) {
        final UniquePos uniquePos = new UniquePos(t);
        this.processArg(t, () -> {
            Attr attr = this.attr;
            attr.getClass();
            JCTree.JCExpression jCExpression2 = (JCTree.JCExpression)this.deferredAttr.attribSpeculative(t, this.env, new Attr.MethodAttrInfo(attr){

                @Override
                protected void attr(JCTree jCTree, Env<AttrContext> env) {
                    if (!new UniquePos(jCTree).equals(uniquePos)) {
                        super.attr(jCTree, env);
                    } else {
                        ArgumentAttr.this.visitTree(jCTree);
                    }
                }
            });
            return (ArgumentType)function.apply(jCExpression2);
        });
    }

    <T extends JCTree.JCExpression, Z extends ArgumentType<T>> void processArg(T t, Supplier<Z> supplier) {
        UniquePos uniquePos = new UniquePos(t);
        ArgumentType<?> argumentType = this.argumentTypeCache.get(uniquePos);
        if (argumentType != null) {
            this.setResult(t, argumentType.dup(t, this.env));
        } else {
            ArgumentType argumentType2 = (ArgumentType)supplier.get();
            this.argumentTypeCache.put(uniquePos, argumentType2);
            this.setResult(t, argumentType2);
        }
    }

    @Override
    public void visitParens(JCTree.JCParens jCParens) {
        this.processArg(jCParens, (T jCParens2) -> new ParensType(jCParens, this.env, (JCTree.JCParens)jCParens2));
    }

    @Override
    public void visitConditional(JCTree.JCConditional jCConditional) {
        this.processArg(jCConditional, (T jCConditional2) -> new ConditionalType(jCConditional, this.env, (JCTree.JCConditional)jCConditional2));
    }

    @Override
    public void visitReference(JCTree.JCMemberReference jCMemberReference) {
        Env<AttrContext> env = this.env.dup(jCMemberReference);
        JCTree.JCExpression jCExpression = (JCTree.JCExpression)this.deferredAttr.attribSpeculative(jCMemberReference.getQualifierExpression(), env, this.attr.memberReferenceQualifierResult(jCMemberReference), this.withLocalCacheContext());
        JCTree.JCMemberReference jCMemberReference2 = new TreeCopier(this.attr.make).copy(jCMemberReference);
        jCMemberReference2.expr = jCExpression;
        Symbol symbol = TreeInfo.symbol(jCExpression);
        ((AttrContext)env.info).selectSuper = symbol != null && symbol.name == symbol.name.table.names._super;
        Symbol symbol2 = this.attr.rs.getMemberReference(jCMemberReference, env, jCMemberReference2, jCExpression.type, jCMemberReference.name);
        if (!symbol2.kind.isResolutionError()) {
            jCMemberReference.sym = symbol2;
        }
        if (symbol2.kind.isResolutionTargetError() || symbol2.type != null && symbol2.type.hasTag(TypeTag.FORALL) || (symbol2.flags() & 0x400000000L) != 0L || TreeInfo.isStaticSelector(jCExpression, jCMemberReference.name.table.names) && jCExpression.type.isRaw() && !jCExpression.type.hasTag(TypeTag.ARRAY)) {
            jCMemberReference.setOverloadKind(JCTree.JCMemberReference.OverloadKind.OVERLOADED);
        } else {
            jCMemberReference.setOverloadKind(JCTree.JCMemberReference.OverloadKind.UNOVERLOADED);
        }
        DeferredAttr deferredAttr = this.deferredAttr;
        deferredAttr.getClass();
        this.setResult(jCMemberReference, new DeferredAttr.DeferredType(deferredAttr, jCMemberReference, this.env));
    }

    @Override
    public void visitLambda(JCTree.JCLambda jCLambda) {
        if (jCLambda.paramKind == JCTree.JCLambda.ParameterKind.EXPLICIT) {
            this.processArg(jCLambda, () -> {
                JCTree.JCLambda jCLambda2 = this.deferredAttr.attribSpeculativeLambda(jCLambda, this.env, this.attr.methodAttrInfo);
                return new ExplicitLambdaType(jCLambda, this.env, jCLambda2);
            });
        } else {
            DeferredAttr deferredAttr = this.deferredAttr;
            deferredAttr.getClass();
            this.setResult(jCLambda, new DeferredAttr.DeferredType(deferredAttr, jCLambda, this.env));
        }
    }

    @Override
    public void visitApply(JCTree.JCMethodInvocation jCMethodInvocation) {
        if (((List)jCMethodInvocation.getTypeArguments()).isEmpty()) {
            this.processArg(jCMethodInvocation, (T jCMethodInvocation2) -> new ResolvedMethodType(jCMethodInvocation, this.env, (JCTree.JCMethodInvocation)jCMethodInvocation2));
        } else {
            this.setResult(jCMethodInvocation, this.attr.attribTree(jCMethodInvocation, this.env, this.attr.unknownExprInfo));
        }
    }

    @Override
    public void visitNewClass(JCTree.JCNewClass jCNewClass) {
        if (TreeInfo.isDiamond(jCNewClass)) {
            this.processArg(jCNewClass, (T jCNewClass2) -> new ResolvedConstructorType(jCNewClass, this.env, (JCTree.JCNewClass)jCNewClass2));
        } else {
            this.setResult(jCNewClass, this.attr.attribTree(jCNewClass, this.env, this.attr.unknownExprInfo));
        }
    }

    class UniquePos {
        int pos;
        DiagnosticSource source;

        UniquePos(JCTree jCTree) {
            this.pos = jCTree.pos;
            this.source = ArgumentAttr.this.log.currentSource();
        }

        public int hashCode() {
            return this.pos << 16 + this.source.hashCode();
        }

        public boolean equals(Object object) {
            if (object instanceof UniquePos) {
                UniquePos uniquePos = (UniquePos)object;
                return this.pos == uniquePos.pos && this.source == uniquePos.source;
            }
            return false;
        }

        public String toString() {
            return this.source.getFile().getName() + " @ " + this.source.getLineNumber(this.pos);
        }
    }

    class ResolvedConstructorType
    extends ResolvedMemberType<JCTree.JCNewClass> {
        public ResolvedConstructorType(JCTree.JCExpression jCExpression, Env<AttrContext> env, JCTree.JCNewClass jCNewClass) {
            this(jCExpression, env, jCNewClass, new HashMap<Attr.ResultInfo, Type>());
        }

        public ResolvedConstructorType(JCTree.JCExpression jCExpression, Env<AttrContext> env, JCTree.JCNewClass jCNewClass, Map<Attr.ResultInfo, Type> map) {
            super(ArgumentAttr.this, jCExpression, env, (JCTree.JCExpression)jCNewClass, map);
        }

        @Override
        Attr.ResultInfo resultInfo(Attr.ResultInfo resultInfo) {
            return resultInfo.dup(ArgumentAttr.this.attr.diamondContext((JCTree.JCNewClass)this.speculativeTree, ((JCTree.JCNewClass)this.speculativeTree).clazz.type.tsym, resultInfo.checkContext));
        }

        @Override
        Type methodType() {
            return ((JCTree.JCNewClass)this.speculativeTree).constructorType != null ? ((JCTree.JCNewClass)this.speculativeTree).constructorType.baseType() : ((ArgumentAttr)ArgumentAttr.this).syms.errType;
        }

        @Override
        ArgumentType<JCTree.JCNewClass> dup(JCTree.JCNewClass jCNewClass, Env<AttrContext> env) {
            return new ResolvedConstructorType(jCNewClass, env, (JCTree.JCNewClass)this.speculativeTree, this.speculativeTypes);
        }
    }

    class ResolvedMethodType
    extends ResolvedMemberType<JCTree.JCMethodInvocation> {
        public ResolvedMethodType(JCTree.JCExpression jCExpression, Env<AttrContext> env, JCTree.JCMethodInvocation jCMethodInvocation) {
            this(jCExpression, env, jCMethodInvocation, new HashMap<Attr.ResultInfo, Type>());
        }

        public ResolvedMethodType(JCTree.JCExpression jCExpression, Env<AttrContext> env, JCTree.JCMethodInvocation jCMethodInvocation, Map<Attr.ResultInfo, Type> map) {
            super(ArgumentAttr.this, jCExpression, env, (JCTree.JCExpression)jCMethodInvocation, map);
        }

        @Override
        Attr.ResultInfo resultInfo(Attr.ResultInfo resultInfo) {
            return resultInfo;
        }

        @Override
        Type methodType() {
            return ((JCTree.JCMethodInvocation)this.speculativeTree).meth.type;
        }

        @Override
        ArgumentType<JCTree.JCMethodInvocation> dup(JCTree.JCMethodInvocation jCMethodInvocation, Env<AttrContext> env) {
            return new ResolvedMethodType(jCMethodInvocation, env, (JCTree.JCMethodInvocation)this.speculativeTree, this.speculativeTypes);
        }
    }

    static abstract class ResolvedMemberType<E extends JCTree.JCExpression>
    extends ArgumentType<E> {
        final /* synthetic */ ArgumentAttr this$0;

        public ResolvedMemberType(JCTree.JCExpression jCExpression, Env<AttrContext> env, E e, Map<Attr.ResultInfo, Type> map) {
            this.this$0 = var1_1;
            super((ArgumentAttr)var1_1, jCExpression, env, e, map);
        }

        @Override
        Type overloadCheck(Attr.ResultInfo resultInfo, DeferredAttr.DeferredAttrContext deferredAttrContext) {
            Type type = this.methodType();
            Attr.ResultInfo resultInfo2 = this.resultInfo(resultInfo);
            Type type2 = type != null && type.hasTag(TypeTag.METHOD) && type.isPartial() ? ((Infer.PartiallyInferredMethodType)type).check(resultInfo2) : resultInfo2.check(this.tree.pos(), this.speculativeTree.type);
            this.speculativeTypes.put(resultInfo2, type2);
            return type2;
        }

        abstract Attr.ResultInfo resultInfo(Attr.ResultInfo var1);

        abstract Type methodType();
    }

    class ExplicitLambdaType
    extends ArgumentType<JCTree.JCLambda> {
        Optional<List<Type>> argtypes;
        Optional<List<JCTree.JCReturn>> returnExpressions;

        ExplicitLambdaType(JCTree.JCLambda jCLambda, Env<AttrContext> env, JCTree.JCLambda jCLambda2) {
            this(jCLambda, env, jCLambda2, new HashMap<Attr.ResultInfo, Type>());
        }

        ExplicitLambdaType(JCTree.JCLambda jCLambda, Env<AttrContext> env, JCTree.JCLambda jCLambda2, Map<Attr.ResultInfo, Type> map) {
            super(ArgumentAttr.this, (JCTree.JCExpression)jCLambda, env, (JCTree.JCExpression)jCLambda2, map);
            this.argtypes = Optional.empty();
            this.returnExpressions = Optional.empty();
        }

        List<Type> argtypes() {
            return this.argtypes.orElseGet(() -> {
                List<Type> list = TreeInfo.types(((JCTree.JCLambda)this.speculativeTree).params);
                this.argtypes = Optional.of(list);
                return list;
            });
        }

        List<JCTree.JCReturn> returnExpressions() {
            return this.returnExpressions.orElseGet(() -> {
                List<JCTree.JCReturn> list;
                if (((JCTree.JCLambda)this.speculativeTree).getBodyKind() == LambdaExpressionTree.BodyKind.EXPRESSION) {
                    list = List.of(((ArgumentAttr)ArgumentAttr.this).attr.make.Return((JCTree.JCExpression)((JCTree.JCLambda)this.speculativeTree).body));
                } else {
                    final ListBuffer listBuffer = new ListBuffer();
                    new DeferredAttr.LambdaReturnScanner(){

                        @Override
                        public void visitReturn(JCTree.JCReturn jCReturn) {
                            listBuffer.add(jCReturn);
                        }
                    }.scan(((JCTree.JCLambda)this.speculativeTree).body);
                    list = listBuffer.toList();
                }
                this.returnExpressions = Optional.of(list);
                return list;
            });
        }

        @Override
        Type overloadCheck(Attr.ResultInfo resultInfo, DeferredAttr.DeferredAttrContext deferredAttrContext) {
            try {
                Attr.TargetInfo targetInfo = ArgumentAttr.this.attr.getTargetInfo((JCTree.JCPolyExpression)this.speculativeTree, resultInfo, this.argtypes());
                Type type = targetInfo.descriptor;
                Type type2 = targetInfo.target;
                this.checkLambdaCompatible(type, resultInfo);
                return type2;
            }
            catch (Types.FunctionDescriptorLookupError functionDescriptorLookupError) {
                resultInfo.checkContext.report(null, functionDescriptorLookupError.getDiagnostic());
                return null;
            }
        }

        private void checkLambdaCompatible(Type type, Attr.ResultInfo resultInfo) {
            Check.CheckContext checkContext = resultInfo.checkContext;
            Attr.ResultInfo resultInfo2 = ArgumentAttr.this.attr.lambdaBodyResult((JCTree.JCLambda)this.speculativeTree, type, resultInfo);
            for (JCTree.JCReturn jCReturn : this.returnExpressions()) {
                Type type2 = this.getReturnType(jCReturn);
                if (((JCTree.JCLambda)this.speculativeTree).getBodyKind() != LambdaExpressionTree.BodyKind.EXPRESSION && type2.hasTag(TypeTag.VOID)) continue;
                ArgumentAttr.this.checkSpeculative(jCReturn.expr, type2, resultInfo2);
            }
            ArgumentAttr.this.attr.checkLambdaCompatible((JCTree.JCLambda)this.speculativeTree, type, checkContext);
        }

        Type getReturnType(JCTree.JCReturn jCReturn) {
            if (jCReturn.expr == null) {
                return ((ArgumentAttr)ArgumentAttr.this).syms.voidType;
            }
            return jCReturn.expr.type;
        }

        @Override
        ArgumentType<JCTree.JCLambda> dup(JCTree.JCLambda jCLambda, Env<AttrContext> env) {
            return new ExplicitLambdaType(jCLambda, env, (JCTree.JCLambda)this.speculativeTree, this.speculativeTypes);
        }
    }

    class ConditionalType
    extends ArgumentType<JCTree.JCConditional> {
        ConditionalType(JCTree.JCExpression jCExpression, Env<AttrContext> env, JCTree.JCConditional jCConditional) {
            this(jCExpression, env, jCConditional, new HashMap<Attr.ResultInfo, Type>());
        }

        ConditionalType(JCTree.JCExpression jCExpression, Env<AttrContext> env, JCTree.JCConditional jCConditional, Map<Attr.ResultInfo, Type> map) {
            super(ArgumentAttr.this, jCExpression, env, (JCTree.JCExpression)jCConditional, map);
        }

        @Override
        Type overloadCheck(Attr.ResultInfo resultInfo, DeferredAttr.DeferredAttrContext deferredAttrContext) {
            Attr.ResultInfo resultInfo2 = resultInfo.dup(ArgumentAttr.this.attr.conditionalContext(resultInfo.checkContext));
            if (((JCTree.JCConditional)this.speculativeTree).isStandalone()) {
                return resultInfo2.check(this.speculativeTree, ((JCTree.JCConditional)this.speculativeTree).type);
            }
            if (resultInfo.pt.hasTag(TypeTag.VOID)) {
                resultInfo.checkContext.report(this.tree, ((ArgumentAttr)ArgumentAttr.this).attr.diags.fragment("conditional.target.cant.be.void", new Object[0]));
                return ((ArgumentAttr)ArgumentAttr.this).attr.types.createErrorType(resultInfo.pt);
            }
            ArgumentAttr.this.checkSpeculative(((JCTree.JCConditional)this.speculativeTree).truepart, resultInfo2);
            ArgumentAttr.this.checkSpeculative(((JCTree.JCConditional)this.speculativeTree).falsepart, resultInfo2);
            return resultInfo2.pt;
        }

        @Override
        ArgumentType<JCTree.JCConditional> dup(JCTree.JCConditional jCConditional, Env<AttrContext> env) {
            return new ConditionalType(jCConditional, env, (JCTree.JCConditional)this.speculativeTree, this.speculativeTypes);
        }
    }

    class ParensType
    extends ArgumentType<JCTree.JCParens> {
        ParensType(JCTree.JCExpression jCExpression, Env<AttrContext> env, JCTree.JCParens jCParens) {
            this(jCExpression, env, jCParens, new HashMap<Attr.ResultInfo, Type>());
        }

        ParensType(JCTree.JCExpression jCExpression, Env<AttrContext> env, JCTree.JCParens jCParens, Map<Attr.ResultInfo, Type> map) {
            super(ArgumentAttr.this, jCExpression, env, (JCTree.JCExpression)jCParens, map);
        }

        @Override
        Type overloadCheck(Attr.ResultInfo resultInfo, DeferredAttr.DeferredAttrContext deferredAttrContext) {
            return ArgumentAttr.this.checkSpeculative(((JCTree.JCParens)this.speculativeTree).expr, resultInfo);
        }

        @Override
        ArgumentType<JCTree.JCParens> dup(JCTree.JCParens jCParens, Env<AttrContext> env) {
            return new ParensType(jCParens, env, (JCTree.JCParens)this.speculativeTree, this.speculativeTypes);
        }
    }

    static abstract class ArgumentType<T extends JCTree.JCExpression>
    extends DeferredAttr.DeferredType
    implements DeferredAttr.DeferredTypeCompleter {
        T speculativeTree;
        Map<Attr.ResultInfo, Type> speculativeTypes;
        final /* synthetic */ ArgumentAttr this$0;

        public ArgumentType(JCTree.JCExpression jCExpression, Env<AttrContext> env, T t, Map<Attr.ResultInfo, Type> map) {
            this.this$0 = var1_1;
            DeferredAttr deferredAttr = ((ArgumentAttr)var1_1).deferredAttr;
            deferredAttr.getClass();
            super(deferredAttr, jCExpression, env);
            this.speculativeTree = t;
            this.speculativeTypes = map;
        }

        @Override
        final DeferredAttr.DeferredTypeCompleter completer() {
            return this;
        }

        @Override
        public final Type complete(DeferredAttr.DeferredType deferredType, Attr.ResultInfo resultInfo, DeferredAttr.DeferredAttrContext deferredAttrContext) {
            Assert.check(deferredType == this);
            if (deferredAttrContext.mode == DeferredAttr.AttrMode.SPECULATIVE) {
                Type type = resultInfo.pt == Type.recoveryType ? ((ArgumentAttr)this.this$0).deferredAttr.basicCompleter.complete(deferredType, resultInfo, deferredAttrContext) : this.overloadCheck(resultInfo, deferredAttrContext);
                this.speculativeTypes.put(resultInfo, type);
                return type;
            }
            if (!((AttrContext)this.env.info).isSpeculative) {
                this.this$0.argumentTypeCache.remove(this.this$0.new UniquePos(deferredType.tree));
            }
            return ((ArgumentAttr)this.this$0).deferredAttr.basicCompleter.complete(deferredType, resultInfo, deferredAttrContext);
        }

        @Override
        Type speculativeType(Symbol symbol, Resolve.MethodResolutionPhase methodResolutionPhase) {
            if (this.pertinentToApplicability) {
                for (Map.Entry<Attr.ResultInfo, Type> entry : this.speculativeTypes.entrySet()) {
                    DeferredAttr.DeferredAttrContext deferredAttrContext = entry.getKey().checkContext.deferredAttrContext();
                    if (deferredAttrContext.phase != methodResolutionPhase || deferredAttrContext.msym != symbol) continue;
                    return entry.getValue();
                }
                return Type.noType;
            }
            return super.speculativeType(symbol, methodResolutionPhase);
        }

        @Override
        JCTree speculativeTree(DeferredAttr.DeferredAttrContext deferredAttrContext) {
            return this.pertinentToApplicability ? this.speculativeTree : super.speculativeTree(deferredAttrContext);
        }

        abstract Type overloadCheck(Attr.ResultInfo var1, DeferredAttr.DeferredAttrContext var2);

        abstract ArgumentType<T> dup(T var1, Env<AttrContext> var2);
    }

    class LocalCacheContext {
        Map<UniquePos, ArgumentType<?>> prevCache;

        public LocalCacheContext() {
            this.prevCache = ArgumentAttr.this.argumentTypeCache;
            ArgumentAttr.this.argumentTypeCache = new HashMap();
        }

        public void leave() {
            ArgumentAttr.this.argumentTypeCache = this.prevCache;
        }
    }
}

