/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.truth.StringUtil;
import java.util.Arrays;

public abstract class FailureStrategy {
    public void fail(String message) {
        this.fail(message, null);
    }

    public void fail(String message, Throwable cause) {
        AssertionError up = new AssertionError((Object)message);
        if (cause == null) {
            cause = new AssertionError((Object)message);
        }
        try {
            ((Throwable)((Object)up)).initCause((Throwable)cause);
        }
        catch (IllegalStateException alreadyInitializedBecauseOfHarmonyBug) {
            throw new AssertionError(cause);
        }
        FailureStrategy.stripTruthStackFrames((Throwable)((Object)up));
        throw up;
    }

    public void failComparing(String message, CharSequence expected, CharSequence actual) {
        this.fail(StringUtil.messageFor(message, expected, actual));
    }

    private static void stripTruthStackFrames(Throwable throwable) {
        int i;
        StackTraceElement[] stackTrace = throwable.getStackTrace();
        for (i = 0; i < stackTrace.length && stackTrace[i].getClassName().startsWith("com.google.common.truth"); ++i) {
        }
        throwable.setStackTrace(Arrays.copyOfRange(stackTrace, i, stackTrace.length));
    }
}

