/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone;

import java.lang.annotation.Annotation;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

@Retention(value=RetentionPolicy.RUNTIME)
public @interface BugPattern {
    public String name();

    public String[] altNames() default {};

    public LinkType linkType() default LinkType.AUTOGENERATED;

    public String link() default "";

    public String[] tags() default {};

    @Deprecated
    public Category category() default Category.ONE_OFF;

    public String summary();

    public String explanation() default "";

    public SeverityLevel severity();

    public Suppressibility suppressibility() default Suppressibility.SUPPRESS_WARNINGS;

    public Class<? extends Annotation>[] customSuppressionAnnotations() default {};

    public boolean documentSuppression() default true;

    public boolean generateExamplesFromTestCases() default true;

    public static enum Suppressibility {
        SUPPRESS_WARNINGS(true),
        CUSTOM_ANNOTATION(false),
        UNSUPPRESSIBLE(false);

        private final boolean disableable;

        private Suppressibility(boolean disableable) {
            this.disableable = disableable;
        }

        public boolean disableable() {
            return this.disableable;
        }
    }

    public static enum SeverityLevel {
        ERROR,
        WARNING,
        SUGGESTION;

    }

    public static enum Category {
        JDK,
        GUAVA,
        GUICE,
        DAGGER,
        JUNIT,
        ONE_OFF,
        INJECT,
        MOCKITO,
        JMOCK,
        ANDROID,
        PROTOBUF,
        TRUTH;

    }

    public static enum LinkType {
        AUTOGENERATED,
        CUSTOM,
        NONE;

    }

    public static final class StandardTags {
        public static final String LIKELY_ERROR = "LikelyError";
        public static final String STYLE = "Style";
        public static final String PERFORMANCE = "Performance";
        public static final String FRAGILE_CODE = "FragileCode";
        public static final String CONCURRENCY = "Concurrency";
        public static final String SIMPLIFICATION = "Simplification";

        private StandardTags() {
        }
    }
}

