/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast;

import lombok.ast.AstException;
import lombok.ast.Block;
import lombok.ast.Expression;
import lombok.ast.Identifier;
import lombok.ast.Modifiers;
import lombok.ast.TypeDeclaration;
import lombok.ast.TypeReference;
import lombok.ast.VariableDeclaration;
import lombok.ast.VariableDefinition;
import lombok.ast.VariableDefinitionEntry;
import lombok.ast.template.ForcedType;

class VariableDefinitionEntryTemplate {
    @ForcedType
    Identifier name1;
    int arrayDimensions2;
    Expression initializer3;

    VariableDefinitionEntryTemplate() {
    }

    static TypeReference getEffectiveTypeReference(VariableDefinitionEntry self) {
        VariableDefinition parent = self.upToVariableDefinition();
        if (parent == null) {
            throw new AstException(self, "Cannot calculate type reference of a VariableDefinitionEntry without a VariableDefinition as parent");
        }
        TypeReference typeRef = parent.astTypeReference().copy();
        return typeRef.astArrayDimensions(typeRef.astArrayDimensions() + self.astArrayDimensions() + (parent.astVarargs() ? 1 : 0));
    }

    static Modifiers getModifiersOfParent(VariableDefinitionEntry self) {
        VariableDefinition parent = self.upToVariableDefinition();
        return parent == null ? new Modifiers() : parent.astModifiers();
    }

    static TypeDeclaration upUpIfFieldToTypeDeclaration(VariableDefinitionEntry self) {
        VariableDefinition def = self.upToVariableDefinition();
        if (def == null) {
            return null;
        }
        VariableDeclaration decl = def.upToVariableDeclaration();
        return decl == null ? null : decl.upUpToTypeDeclaration();
    }

    static Block upUpIfLocalVariableToBlock(VariableDefinitionEntry self) {
        VariableDefinition def = self.upToVariableDefinition();
        if (def == null) {
            return null;
        }
        VariableDeclaration decl = def.upToVariableDeclaration();
        return decl == null ? null : decl.upToBlock();
    }
}

