/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast;

import lombok.ast.CharLiteral;

class CharLiteralTemplate {
    Character value1;

    CharLiteralTemplate() {
    }

    static String getDescription(CharLiteral self) {
        return self.astValue() != null ? String.valueOf(self.astValue()) : null;
    }

    static String toEscape(char c, boolean forCharLiteral, char next) {
        if (c == '\'') {
            return forCharLiteral ? "\\'" : "'";
        }
        if (c == '\"') {
            return forCharLiteral ? "\"" : "\\\"";
        }
        if (c == '\b') {
            return "\\b";
        }
        if (c == '\t') {
            return "\\t";
        }
        if (c == '\n') {
            return "\\n";
        }
        if (c == '\f') {
            return "\\f";
        }
        if (c == '\r') {
            return "\\r";
        }
        if (c == '\\') {
            return "\\\\";
        }
        if (c < ' ' || c == '\u007f') {
            boolean fill;
            String octalEscape = Integer.toString(c, 8);
            boolean bl = fill = next >= '0' && next <= '7' && octalEscape.length() < 3;
            while (fill && octalEscape.length() < 3) {
                octalEscape = "0" + octalEscape;
            }
            return "\\" + octalEscape;
        }
        return "" + c;
    }

    static char fromEscape(char x) {
        if (x == 'b') {
            return '\b';
        }
        if (x == 't') {
            return '\t';
        }
        if (x == 'n') {
            return '\n';
        }
        if (x == 'f') {
            return '\f';
        }
        if (x == 'r') {
            return '\r';
        }
        if (x == '\'') {
            return '\'';
        }
        if (x == '\"') {
            return '\"';
        }
        if (x == '\\') {
            return '\\';
        }
        return '\u0000';
    }

    static String generateChar(Character c) {
        return "'" + CharLiteralTemplate.toEscape(c.charValue(), true, 'a') + "'";
    }

    static Character parseChar(String raw) {
        if (raw == null) {
            throw new IllegalArgumentException("missing character literal");
        }
        String v = raw.trim();
        if (!v.startsWith("'") || !v.endsWith("'")) {
            throw new IllegalArgumentException("Character literals should be enclosed in single quotes: " + v);
        }
        String content = v.substring(1, v.length() - 1);
        if (content.length() == 0) {
            throw new IllegalArgumentException("Empty character literal not allowed");
        }
        if (content.charAt(0) == '\\') {
            if (content.length() == 1) {
                throw new IllegalArgumentException("Incomplete backslash escape: '\\'");
            }
            char x = content.charAt(1);
            char fromEscape = CharLiteralTemplate.fromEscape(x);
            if (fromEscape != '\u0000' && content.length() == 2) {
                return Character.valueOf(fromEscape);
            }
            if (x >= '0' && x <= '7') {
                try {
                    int possible = Integer.parseInt(content.substring(1), 8);
                    if (possible <= 255) {
                        return Character.valueOf((char)possible);
                    }
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            throw new IllegalArgumentException("Not a valid character literal: " + v);
        }
        if (content.length() == 1) {
            char x = content.charAt(0);
            if (x == '\'' || x == '\n' || x == '\r') {
                throw new IllegalArgumentException("Not a valid character literal: " + v);
            }
            return Character.valueOf(x);
        }
        throw new IllegalArgumentException("Not a valid character literal: " + v);
    }
}

