/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.core.internal.instr;

import org.jacoco.core.internal.flow.ClassProbesVisitor;
import org.jacoco.core.internal.flow.MethodProbesVisitor;
import org.jacoco.core.internal.instr.DuplicateFrameEliminator;
import org.jacoco.core.internal.instr.IProbeArrayStrategy;
import org.jacoco.core.internal.instr.InstrSupport;
import org.jacoco.core.internal.instr.MethodInstrumenter;
import org.jacoco.core.internal.instr.ProbeInserter;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;

public class ClassInstrumenter
extends ClassProbesVisitor {
    private final IProbeArrayStrategy probeArrayStrategy;
    private String className;

    public ClassInstrumenter(IProbeArrayStrategy probeArrayStrategy, ClassVisitor cv) {
        super(cv);
        this.probeArrayStrategy = probeArrayStrategy;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.className = name;
        super.visit(version, access, name, signature, superName, interfaces);
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        InstrSupport.assertNotInstrumented(name, this.className);
        return super.visitField(access, name, desc, signature, value);
    }

    public MethodProbesVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        InstrSupport.assertNotInstrumented(name, this.className);
        MethodVisitor mv = this.cv.visitMethod(access, name, desc, signature, exceptions);
        if (mv == null) {
            return null;
        }
        DuplicateFrameEliminator frameEliminator = new DuplicateFrameEliminator(mv);
        ProbeInserter probeVariableInserter = new ProbeInserter(access, desc, frameEliminator, this.probeArrayStrategy);
        return new MethodInstrumenter(probeVariableInserter, probeVariableInserter);
    }

    public void visitTotalProbeCount(int count) {
        this.probeArrayStrategy.addMembers(this.cv, count);
    }
}

