/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.blame.parser;

import com.android.ide.common.blame.Message;
import com.android.ide.common.blame.SourceFilePosition;
import com.android.ide.common.blame.parser.ParsingFailedException;
import com.android.ide.common.blame.parser.PatternAwareOutputParser;
import com.android.ide.common.blame.parser.util.OutputLineReader;
import com.android.utils.ILogger;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class DexParser
implements PatternAwareOutputParser {
    static final String DEX_TOOL_NAME = "Dex";
    static final String DEX_LIMIT_EXCEEDED_ERROR = "The number of method references in a .dex file cannot exceed 64K.\nLearn how to resolve this issue at https://developer.android.com/tools/building/multidex.html";
    private static final String COULD_NOT_CONVERT_BYTECODE_TO_DEX = "Error converting bytecode to dex:\nCause: %s";

    @Override
    public boolean parse(String line, OutputLineReader reader, List<Message> messages, ILogger logger) throws ParsingFailedException {
        if (line.startsWith("processing ") && line.endsWith("...")) {
            logger.verbose(line, new Object[0]);
            return true;
        }
        if (line.startsWith("writing ") && line.endsWith("size 0...")) {
            logger.verbose(line, new Object[0]);
            return true;
        }
        if (line.startsWith("ignored resource ") && line.endsWith("/")) {
            logger.verbose(line, new Object[0]);
            return true;
        }
        if (line.startsWith("trouble writing output: Too many method references:")) {
            StringBuilder original1 = new StringBuilder(line).append('\n');
            String nextLine = reader.readLine();
            while (!Strings.isNullOrEmpty((String)nextLine)) {
                original1.append(nextLine).append('\n');
                nextLine = reader.readLine();
            }
            messages.add(new Message(Message.Kind.ERROR, DEX_LIMIT_EXCEEDED_ERROR, original1.toString(), Optional.of((Object)DEX_TOOL_NAME), ImmutableList.of((Object)SourceFilePosition.UNKNOWN)));
            return true;
        }
        if (!line.equals("UNEXPECTED TOP-LEVEL EXCEPTION:")) {
            return false;
        }
        StringBuilder original = new StringBuilder(line).append('\n');
        String exception = reader.readLine();
        if (exception == null) {
            reader.pushBack();
            return false;
        }
        if (exception.startsWith("com.android.dex.DexIndexOverflowException: method ID not in [0, 0xffff]: ")) {
            original.append(exception).append('\n');
            DexParser.consumeStacktrace(reader, original);
            messages.add(new Message(Message.Kind.ERROR, DEX_LIMIT_EXCEEDED_ERROR, original.toString(), Optional.of((Object)DEX_TOOL_NAME), ImmutableList.of((Object)SourceFilePosition.UNKNOWN)));
            return true;
        }
        original.append(exception).append('\n');
        DexParser.consumeStacktrace(reader, original);
        messages.add(new Message(Message.Kind.ERROR, String.format(COULD_NOT_CONVERT_BYTECODE_TO_DEX, exception), original.toString(), Optional.of((Object)DEX_TOOL_NAME), ImmutableList.of((Object)SourceFilePosition.UNKNOWN)));
        return true;
    }

    private static void consumeStacktrace(OutputLineReader reader, StringBuilder out) {
        String nextLine = reader.readLine();
        while (nextLine != null && (nextLine.startsWith("\t") || nextLine.startsWith("Caused by: "))) {
            out.append(nextLine).append('\n');
            nextLine = reader.readLine();
        }
        if (nextLine != null) {
            reader.pushBack();
        }
    }
}

