/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.blame;

import com.android.ide.common.blame.MergingLog;
import com.android.ide.common.blame.Message;
import com.android.ide.common.blame.MessageReceiver;
import com.android.ide.common.blame.SourceFilePosition;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;

public class MergingLogRewriter
implements MessageReceiver {
    private final MessageReceiver mMessageReceiver;
    private final Function<SourceFilePosition, SourceFilePosition> mGetOriginalPosition;

    public MergingLogRewriter(final MergingLog mergingLog, MessageReceiver messageReceiver) {
        this.mMessageReceiver = messageReceiver;
        this.mGetOriginalPosition = new Function<SourceFilePosition, SourceFilePosition>(){

            public SourceFilePosition apply(SourceFilePosition input) {
                return mergingLog.find(input);
            }
        };
    }

    @Override
    public void receiveMessage(Message message) {
        List originalPositions = message.getSourceFilePositions();
        Iterable positions = Iterables.transform((Iterable)originalPositions, this.mGetOriginalPosition);
        this.mMessageReceiver.receiveMessage(new Message(message.getKind(), message.getText(), message.getRawMessage(), message.getToolName(), ImmutableList.copyOf((Iterable)positions)));
    }
}

