/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.sjavac.pubapi;

import com.sun.tools.sjavac.pubapi.PubApiTypeParam;
import com.sun.tools.sjavac.pubapi.TypeDesc;
import java.io.Serializable;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;

public class PubMethod
implements Serializable {
    private static final long serialVersionUID = -7813050194553446243L;
    Set<Modifier> modifiers;
    List<PubApiTypeParam> typeParams;
    TypeDesc returnType;
    String identifier;
    List<TypeDesc> paramTypes;
    List<TypeDesc> throwDecls;

    public PubMethod(Set<Modifier> modifiers, List<PubApiTypeParam> typeParams, TypeDesc returnType, String identifier, List<TypeDesc> paramTypes, List<TypeDesc> throwDecls) {
        this.modifiers = modifiers;
        this.typeParams = typeParams;
        this.returnType = returnType;
        this.identifier = identifier;
        this.paramTypes = paramTypes;
        this.throwDecls = throwDecls;
    }

    public String asSignatureString() {
        StringBuilder sb = new StringBuilder();
        if (this.typeParams.size() > 0) {
            sb.append(this.typeParams.stream().map(PubApiTypeParam::asString).collect(Collectors.joining(",", "<", "> ")));
        }
        sb.append(TypeDesc.encodeAsString(this.returnType));
        sb.append(" ");
        sb.append(this.identifier);
        sb.append("(");
        sb.append(this.paramTypes.stream().map(TypeDesc::encodeAsString).collect(Collectors.joining(",")));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PubMethod other = (PubMethod)obj;
        return this.modifiers.equals(other.modifiers) && this.typeParams.equals(other.typeParams) && this.returnType.equals(other.returnType) && this.identifier.equals(other.identifier) && this.paramTypes.equals(other.paramTypes) && this.throwDecls.equals(other.throwDecls);
    }

    public int hashCode() {
        return this.modifiers.hashCode() ^ this.typeParams.hashCode() ^ this.returnType.hashCode() ^ this.identifier.hashCode() ^ this.paramTypes.hashCode() ^ this.throwDecls.hashCode();
    }

    public String toString() {
        return String.format("%s[modifiers: %s, typeParams: %s, retType: %s, identifier: %s, params: %s, throws: %s]", this.getClass().getSimpleName(), this.modifiers, this.typeParams, this.returnType, this.identifier, this.paramTypes, this.throwDecls);
    }
}

