/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.sjavac.comp;

import com.sun.tools.javac.api.ClientCodeWrapper;
import com.sun.tools.javac.file.JavacFileManager;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.sjavac.comp.FileObjectWithLocation;
import com.sun.tools.sjavac.comp.JavaFileObjectWithLocation;
import com.sun.tools.sjavac.comp.SmartFileObject;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;

@ClientCodeWrapper.Trusted
public class SmartFileManager
extends ForwardingJavaFileManager<JavaFileManager> {
    Set<URI> visibleSources = new HashSet<URI>();
    Map<String, Set<URI>> packageArtifacts = new HashMap<String, Set<URI>>();
    PrintWriter stdout;

    public SmartFileManager(JavaFileManager fileManager) {
        super(fileManager);
    }

    public void setVisibleSources(Set<URI> s) {
        this.visibleSources = s;
    }

    public void cleanArtifacts() {
        this.packageArtifacts = new HashMap<String, Set<URI>>();
    }

    public void setLog(PrintWriter pw) {
        this.stdout = pw;
    }

    public void setSymbolFileEnabled(boolean b) {
        if (!(this.fileManager instanceof JavacFileManager)) {
            throw new IllegalStateException();
        }
        ((JavacFileManager)this.fileManager).setSymbolFileEnabled(b);
    }

    @Override
    public String inferBinaryName(JavaFileManager.Location location, JavaFileObject file) {
        return super.inferBinaryName(location, SmartFileManager.locUnwrap(file));
    }

    public Map<String, Set<URI>> getPackageArtifacts() {
        return this.packageArtifacts;
    }

    @Override
    public Iterable<JavaFileObject> list(JavaFileManager.Location location, String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
        Iterable<JavaFileObject> files = super.list(location, packageName, kinds, recurse);
        if (this.visibleSources.isEmpty()) {
            return SmartFileManager.locWrapMany(files, location);
        }
        ListBuffer<JavaFileObject> filteredFiles = new ListBuffer<JavaFileObject>();
        for (JavaFileObject f : files) {
            URI uri = f.toUri();
            String t = uri.toString();
            if (!t.startsWith("jar:") && !t.endsWith(".class") && !this.visibleSources.contains(uri)) continue;
            filteredFiles.add(f);
        }
        return SmartFileManager.locWrapMany(filteredFiles, location);
    }

    @Override
    public JavaFileObject getJavaFileForInput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind) throws IOException {
        JavaFileObject file = super.getJavaFileForInput(location, className, kind);
        if ((file = SmartFileManager.locWrap(file, location)) == null || this.visibleSources.isEmpty()) {
            return file;
        }
        if (this.visibleSources.contains(file.toUri())) {
            return file;
        }
        return null;
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
        JavaFileObject file = super.getJavaFileForOutput(location, className, kind, sibling);
        if ((file = SmartFileManager.locWrap(file, location)) == null) {
            return file;
        }
        int dp = className.lastIndexOf(46);
        String pkg_name = "";
        if (dp != -1) {
            pkg_name = className.substring(0, dp);
        }
        String mod_name = "";
        this.addArtifact(mod_name + ":" + pkg_name, file.toUri());
        return file;
    }

    @Override
    public FileObject getFileForInput(JavaFileManager.Location location, String packageName, String relativeName) throws IOException {
        FileObject file = super.getFileForInput(location, packageName, relativeName);
        if ((file = SmartFileManager.locWrap(file, location)) == null || this.visibleSources.isEmpty()) {
            return file;
        }
        if (this.visibleSources.contains(file.toUri())) {
            return file;
        }
        return null;
    }

    @Override
    public FileObject getFileForOutput(JavaFileManager.Location location, String packageName, String relativeName, FileObject sibling) throws IOException {
        FileObject superFile = super.getFileForOutput(location, packageName, relativeName, sibling);
        FileObject file = SmartFileManager.locWrap(superFile, location);
        if (file == null) {
            return file;
        }
        if (location.equals(StandardLocation.NATIVE_HEADER_OUTPUT) && superFile instanceof JavaFileObject) {
            file = new SmartFileObject((JavaFileObject)file, this.stdout);
            packageName = ":" + SmartFileManager.packageNameFromFileName(relativeName);
        }
        if (packageName.equals("")) {
            packageName = ":";
        }
        this.addArtifact(packageName, file.toUri());
        return file;
    }

    private static String packageNameFromFileName(String fn) {
        StringBuilder sb = new StringBuilder();
        int p = fn.indexOf(95);
        int pp = 0;
        while (p != -1) {
            if (sb.length() > 0) {
                sb.append('.');
            }
            sb.append(fn.substring(pp, p));
            if (p == fn.length() - 1) break;
            pp = p + 1;
            p = fn.indexOf(95, pp);
        }
        return sb.toString();
    }

    void addArtifact(String pkgName, URI art) {
        Set<URI> s = this.packageArtifacts.get(pkgName);
        if (s == null) {
            s = new HashSet<URI>();
            this.packageArtifacts.put(pkgName, s);
        }
        s.add(art);
    }

    public static JavaFileObject locWrap(JavaFileObject jfo, JavaFileManager.Location loc) {
        if (loc == StandardLocation.PLATFORM_CLASS_PATH) {
            return jfo;
        }
        return jfo == null ? null : new JavaFileObjectWithLocation<JavaFileObject>(jfo, loc);
    }

    private static FileObject locWrap(FileObject fo, JavaFileManager.Location loc) {
        if (fo instanceof JavaFileObject) {
            return SmartFileManager.locWrap((JavaFileObject)fo, loc);
        }
        return fo == null ? null : new FileObjectWithLocation<FileObject>(fo, loc);
    }

    @Override
    public boolean isSameFile(FileObject a, FileObject b) {
        return super.isSameFile(SmartFileManager.locUnwrap(a), SmartFileManager.locUnwrap(b));
    }

    private static ListBuffer<JavaFileObject> locWrapMany(Iterable<JavaFileObject> jfos, JavaFileManager.Location loc) {
        ListBuffer<JavaFileObject> locWrapped = new ListBuffer<JavaFileObject>();
        for (JavaFileObject f : jfos) {
            locWrapped.add(SmartFileManager.locWrap(f, loc));
        }
        return locWrapped;
    }

    private static FileObject locUnwrap(FileObject fo) {
        if (fo instanceof FileObjectWithLocation) {
            return ((FileObjectWithLocation)fo).getDelegate();
        }
        if (fo instanceof JavaFileObjectWithLocation) {
            return ((JavaFileObjectWithLocation)fo).getDelegate();
        }
        return fo;
    }

    private static JavaFileObject locUnwrap(JavaFileObject fo) {
        if (fo instanceof JavaFileObjectWithLocation) {
            return ((JavaFileObjectWithLocation)fo).getDelegate();
        }
        return fo;
    }
}

