/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.code;

import com.sun.tools.javac.api.Messages;
import com.sun.tools.javac.code.BoundKind;
import com.sun.tools.javac.code.Kinds;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import java.util.Locale;

public abstract class Printer
implements Type.Visitor<String, Locale>,
Symbol.Visitor<String, Locale> {
    List<Type> seenCaptured = List.nil();
    static final int PRIME = 997;

    protected Printer() {
    }

    protected abstract String localize(Locale var1, String var2, Object ... var3);

    protected abstract String capturedVarId(Type.CapturedType var1, Locale var2);

    public static Printer createStandardPrinter(final Messages messages) {
        return new Printer(){

            @Override
            protected String localize(Locale locale, String key, Object ... args) {
                return messages.getLocalizedString(locale, key, args);
            }

            @Override
            protected String capturedVarId(Type.CapturedType t, Locale locale) {
                return ((long)t.hashCode() & 0xFFFFFFFFL) % 997L + "";
            }
        };
    }

    public String visitTypes(List<Type> ts, Locale locale) {
        ListBuffer<String> sbuf = new ListBuffer<String>();
        for (Type t : ts) {
            sbuf.append(this.visit(t, locale));
        }
        return sbuf.toList().toString();
    }

    public String visitSymbols(List<Symbol> ts, Locale locale) {
        ListBuffer<String> sbuf = new ListBuffer<String>();
        for (Symbol t : ts) {
            sbuf.append(this.visit(t, locale));
        }
        return sbuf.toList().toString();
    }

    public String visit(Type t, Locale locale) {
        return t.accept(this, locale);
    }

    public String visit(Symbol s, Locale locale) {
        return s.accept(this, locale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String visitCapturedType(Type.CapturedType t, Locale locale) {
        if (this.seenCaptured.contains(t)) {
            return this.printAnnotations(t) + this.localize(locale, "compiler.misc.type.captureof.1", this.capturedVarId(t, locale));
        }
        try {
            this.seenCaptured = this.seenCaptured.prepend(t);
            String string = this.printAnnotations(t) + this.localize(locale, "compiler.misc.type.captureof", this.capturedVarId(t, locale), this.visit(t.wildcard, locale));
            return string;
        }
        finally {
            this.seenCaptured = this.seenCaptured.tail;
        }
    }

    @Override
    public String visitForAll(Type.ForAll t, Locale locale) {
        return this.printAnnotations(t) + "<" + this.visitTypes(t.tvars, locale) + ">" + this.visit(t.qtype, locale);
    }

    @Override
    public String visitUndetVar(Type.UndetVar t, Locale locale) {
        if (t.inst != null) {
            return this.printAnnotations(t) + this.visit(t.inst, locale);
        }
        return this.printAnnotations(t) + this.visit(t.qtype, locale) + "?";
    }

    @Override
    public String visitArrayType(Type.ArrayType t, Locale locale) {
        StringBuilder res = new StringBuilder();
        this.printBaseElementType(t, res, locale);
        this.printBrackets(t, res, locale);
        return res.toString();
    }

    private String printAnnotations(Type t) {
        return this.printAnnotations(t, false);
    }

    private String printAnnotations(Type t, boolean prefix) {
        StringBuilder sb = new StringBuilder();
        java.util.List annos = t.getAnnotationMirrors();
        if (!((List)annos).isEmpty()) {
            if (prefix) {
                sb.append(' ');
            }
            sb.append(annos);
            sb.append(' ');
        }
        return sb.toString();
    }

    private void printBaseElementType(Type t, StringBuilder sb, Locale locale) {
        Type arrel = t;
        while (arrel.hasTag(TypeTag.ARRAY)) {
            arrel = ((Type.ArrayType)arrel).elemtype;
        }
        sb.append(this.visit(arrel, locale));
    }

    private void printBrackets(Type t, StringBuilder sb, Locale locale) {
        Type arrel = t;
        while (arrel.hasTag(TypeTag.ARRAY)) {
            sb.append(this.printAnnotations(arrel, true));
            sb.append("[]");
            arrel = ((Type.ArrayType)arrel).elemtype;
        }
    }

    @Override
    public String visitClassType(Type.ClassType t, Locale locale) {
        StringBuilder buf = new StringBuilder();
        if (t.getEnclosingType().hasTag(TypeTag.CLASS) && t.tsym.owner.kind == Kinds.Kind.TYP) {
            buf.append(this.visit(t.getEnclosingType(), locale));
            buf.append('.');
            buf.append(this.printAnnotations(t));
            buf.append(this.className(t, false, locale));
        } else {
            buf.append(this.printAnnotations(t));
            buf.append(this.className(t, true, locale));
        }
        if (((List)t.getTypeArguments()).nonEmpty()) {
            buf.append('<');
            buf.append(this.visitTypes((List<Type>)t.getTypeArguments(), locale));
            buf.append('>');
        }
        return buf.toString();
    }

    @Override
    public String visitMethodType(Type.MethodType t, Locale locale) {
        return "(" + this.printMethodArgs(t.argtypes, false, locale) + ")" + this.visit(t.restype, locale);
    }

    @Override
    public String visitPackageType(Type.PackageType t, Locale locale) {
        return t.tsym.getQualifiedName().toString();
    }

    @Override
    public String visitWildcardType(Type.WildcardType t, Locale locale) {
        StringBuilder s = new StringBuilder();
        s.append((Object)t.kind);
        if (t.kind != BoundKind.UNBOUND) {
            s.append(this.printAnnotations(t));
            s.append(this.visit(t.type, locale));
        }
        return s.toString();
    }

    @Override
    public String visitErrorType(Type.ErrorType t, Locale locale) {
        return this.visitType((Type)t, locale);
    }

    @Override
    public String visitTypeVar(Type.TypeVar t, Locale locale) {
        return this.visitType((Type)t, locale);
    }

    @Override
    public String visitType(Type t, Locale locale) {
        String s = t.tsym == null || t.tsym.name == null ? this.localize(locale, "compiler.misc.type.none", new Object[0]) : t.tsym.name.toString();
        return s;
    }

    protected String className(Type.ClassType t, boolean longform, Locale locale) {
        Symbol.TypeSymbol sym = t.tsym;
        if (sym.name.length() == 0 && (sym.flags() & 0x1000000L) != 0L) {
            StringBuilder s = new StringBuilder(this.visit(t.supertype_field, locale));
            List<Type> is = t.interfaces_field;
            while (is.nonEmpty()) {
                s.append('&');
                s.append(this.visit((Type)is.head, locale));
                is = is.tail;
            }
            return s.toString();
        }
        if (sym.name.length() == 0) {
            Type.ClassType norm = (Type.ClassType)t.tsym.type;
            String s = norm == null ? this.localize(locale, "compiler.misc.anonymous.class", new Object[]{null}) : (norm.interfaces_field != null && norm.interfaces_field.nonEmpty() ? this.localize(locale, "compiler.misc.anonymous.class", this.visit((Type)norm.interfaces_field.head, locale)) : this.localize(locale, "compiler.misc.anonymous.class", this.visit(norm.supertype_field, locale)));
            return s;
        }
        if (longform) {
            return sym.getQualifiedName().toString();
        }
        return sym.name.toString();
    }

    protected String printMethodArgs(List<Type> args, boolean varArgs, Locale locale) {
        if (!varArgs) {
            return this.visitTypes(args, locale);
        }
        StringBuilder buf = new StringBuilder();
        while (args.tail.nonEmpty()) {
            buf.append(this.visit((Type)args.head, locale));
            args = args.tail;
            buf.append(',');
        }
        if (((Type)args.head).hasTag(TypeTag.ARRAY)) {
            buf.append(this.visit(((Type.ArrayType)args.head).elemtype, locale));
            if (((List)((Type)args.head).getAnnotationMirrors()).nonEmpty()) {
                buf.append(' ');
                buf.append(((Type)args.head).getAnnotationMirrors());
                buf.append(' ');
            }
            buf.append("...");
        } else {
            buf.append(this.visit((Type)args.head, locale));
        }
        return buf.toString();
    }

    @Override
    public String visitClassSymbol(Symbol.ClassSymbol sym, Locale locale) {
        return sym.name.isEmpty() ? this.localize(locale, "compiler.misc.anonymous.class", sym.flatname) : sym.fullname.toString();
    }

    @Override
    public String visitMethodSymbol(Symbol.MethodSymbol s, Locale locale) {
        String ms;
        if (s.isStaticOrInstanceInit()) {
            return s.owner.name.toString();
        }
        String string = ms = s.name == s.name.table.names.init ? s.owner.name.toString() : s.name.toString();
        if (s.type != null) {
            if (s.type.hasTag(TypeTag.FORALL)) {
                ms = "<" + this.visitTypes(s.type.getTypeArguments(), locale) + ">" + ms;
            }
            ms = ms + "(" + this.printMethodArgs(s.type.getParameterTypes(), (s.flags() & 0x400000000L) != 0L, locale) + ")";
        }
        return ms;
    }

    @Override
    public String visitOperatorSymbol(Symbol.OperatorSymbol s, Locale locale) {
        return this.visitMethodSymbol((Symbol.MethodSymbol)s, locale);
    }

    @Override
    public String visitPackageSymbol(Symbol.PackageSymbol s, Locale locale) {
        return s.isUnnamed() ? this.localize(locale, "compiler.misc.unnamed.package", new Object[0]) : s.fullname.toString();
    }

    @Override
    public String visitTypeSymbol(Symbol.TypeSymbol s, Locale locale) {
        return this.visitSymbol((Symbol)s, locale);
    }

    @Override
    public String visitVarSymbol(Symbol.VarSymbol s, Locale locale) {
        return this.visitSymbol((Symbol)s, locale);
    }

    @Override
    public String visitSymbol(Symbol s, Locale locale) {
        return s.name.toString();
    }
}

