/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.api;

import com.sun.source.util.JavacTask;
import com.sun.tools.javac.Main;
import com.sun.tools.javac.api.ClientCodeWrapper;
import com.sun.tools.javac.api.JavacTaskImpl;
import com.sun.tools.javac.file.BaseFileManager;
import com.sun.tools.javac.file.JavacFileManager;
import com.sun.tools.javac.main.Arguments;
import com.sun.tools.javac.main.Option;
import com.sun.tools.javac.util.ClientCodeException;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.PropagatedException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import javax.lang.model.SourceVersion;
import javax.tools.DiagnosticListener;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;

public final class JavacTool
implements JavaCompiler {
    @Deprecated
    public JavacTool() {
    }

    public static JavacTool create() {
        return new JavacTool();
    }

    @Override
    public JavacFileManager getStandardFileManager(DiagnosticListener<? super JavaFileObject> diagnosticListener, Locale locale, Charset charset) {
        Context context = new Context();
        context.put(Locale.class, locale);
        if (diagnosticListener != null) {
            context.put(DiagnosticListener.class, diagnosticListener);
        }
        PrintWriter pw = charset == null ? new PrintWriter(System.err, true) : new PrintWriter((Writer)new OutputStreamWriter((OutputStream)System.err, charset), true);
        context.put(Log.outKey, pw);
        return new JavacFileManager(context, true, charset);
    }

    @Override
    public JavacTask getTask(Writer out, JavaFileManager fileManager, DiagnosticListener<? super JavaFileObject> diagnosticListener, Iterable<String> options, Iterable<String> classes, Iterable<? extends JavaFileObject> compilationUnits) {
        Context context = new Context();
        return this.getTask(out, fileManager, diagnosticListener, options, classes, compilationUnits, context);
    }

    public JavacTask getTask(Writer out, JavaFileManager fileManager, DiagnosticListener<? super JavaFileObject> diagnosticListener, Iterable<String> options, Iterable<String> classes, Iterable<? extends JavaFileObject> compilationUnits, Context context) {
        try {
            ClientCodeWrapper ccw = ClientCodeWrapper.instance(context);
            if (options != null) {
                for (String string : options) {
                    Objects.requireNonNull(string);
                }
            }
            if (classes != null) {
                for (String string : classes) {
                    if (SourceVersion.isName(string)) continue;
                    throw new IllegalArgumentException("Not a valid class name: " + string);
                }
            }
            if (compilationUnits != null) {
                compilationUnits = ccw.wrapJavaFileObjects(compilationUnits);
                for (JavaFileObject javaFileObject : compilationUnits) {
                    if (javaFileObject.getKind() == JavaFileObject.Kind.SOURCE) continue;
                    String kindMsg = "Compilation unit is not of SOURCE kind: \"" + javaFileObject.getName() + "\"";
                    throw new IllegalArgumentException(kindMsg);
                }
            }
            if (diagnosticListener != null) {
                context.put(DiagnosticListener.class, ccw.wrap(diagnosticListener));
            }
            if (out == null) {
                context.put(Log.outKey, new PrintWriter(System.err, true));
            } else {
                context.put(Log.outKey, new PrintWriter(out, true));
            }
            if (fileManager == null && (fileManager = this.getStandardFileManager((DiagnosticListener)diagnosticListener, (Locale)null, (Charset)null)) instanceof BaseFileManager) {
                ((BaseFileManager)fileManager).autoClose = true;
            }
            fileManager = ccw.wrap(fileManager);
            context.put(JavaFileManager.class, fileManager);
            Arguments args = Arguments.instance(context);
            args.init("javac", options, classes, compilationUnits);
            return new JavacTaskImpl(context);
        }
        catch (PropagatedException ex) {
            throw ex.getCause();
        }
        catch (ClientCodeException ex) {
            throw new RuntimeException(ex.getCause());
        }
    }

    @Override
    public int run(InputStream in, OutputStream out, OutputStream err, String ... arguments) {
        if (err == null) {
            err = System.err;
        }
        for (String argument : arguments) {
            Objects.requireNonNull(argument);
        }
        return Main.compile(arguments, new PrintWriter(err, true));
    }

    @Override
    public Set<SourceVersion> getSourceVersions() {
        return Collections.unmodifiableSet(EnumSet.range(SourceVersion.RELEASE_3, SourceVersion.latest()));
    }

    @Override
    public int isSupportedOption(String option) {
        Set<Option> recognizedOptions = Option.getJavacToolOptions();
        for (Option o : recognizedOptions) {
            if (!o.matches(option)) continue;
            return o.hasArg() ? 1 : 0;
        }
        return -1;
    }
}

