/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import com.googlecode.javaewah.EWAHCompressedBitmap;
import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Arrays;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.file.BasePackBitmapIndex;
import org.eclipse.jgit.internal.storage.file.PackIndex;
import org.eclipse.jgit.internal.storage.file.PackReverseIndex;
import org.eclipse.jgit.internal.storage.file.SimpleDataInput;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdOwnerMap;
import org.eclipse.jgit.util.IO;
import org.eclipse.jgit.util.NB;

class PackBitmapIndexV1
extends BasePackBitmapIndex {
    static final byte[] MAGIC = new byte[]{66, 73, 84, 77};
    static final int OPT_FULL = 1;
    private static final int MAX_XOR_OFFSET = 126;
    private final PackIndex packIndex;
    private final PackReverseIndex reverseIndex;
    private final EWAHCompressedBitmap commits;
    private final EWAHCompressedBitmap trees;
    private final EWAHCompressedBitmap blobs;
    private final EWAHCompressedBitmap tags;
    private final ObjectIdOwnerMap<BasePackBitmapIndex.StoredBitmap> bitmaps;

    PackBitmapIndexV1(InputStream fd, PackIndex packIndex, PackReverseIndex reverseIndex) throws IOException {
        super(new ObjectIdOwnerMap<BasePackBitmapIndex.StoredBitmap>());
        this.packIndex = packIndex;
        this.reverseIndex = reverseIndex;
        this.bitmaps = this.getBitmaps();
        byte[] scratch = new byte[32];
        IO.readFully(fd, scratch, 0, scratch.length);
        for (int i = 0; i < MAGIC.length; ++i) {
            if (scratch[i] == MAGIC[i]) continue;
            byte[] actual = new byte[MAGIC.length];
            System.arraycopy(scratch, 0, actual, 0, MAGIC.length);
            throw new IOException(MessageFormat.format(JGitText.get().expectedGot, Arrays.toString(MAGIC), Arrays.toString(actual)));
        }
        int version = NB.decodeUInt16(scratch, 4);
        if (version != 1) {
            throw new IOException(MessageFormat.format(JGitText.get().unsupportedPackIndexVersion, version));
        }
        int opts = NB.decodeUInt16(scratch, 6);
        if ((opts & 1) == 0) {
            throw new IOException(MessageFormat.format(JGitText.get().expectedGot, 1, opts));
        }
        long numEntries = NB.decodeUInt32(scratch, 8);
        if (numEntries > Integer.MAX_VALUE) {
            throw new IOException(JGitText.get().indexFileIsTooLargeForJgit);
        }
        this.packChecksum = new byte[20];
        System.arraycopy(scratch, 12, this.packChecksum, 0, this.packChecksum.length);
        SimpleDataInput dataInput = new SimpleDataInput(fd);
        this.commits = PackBitmapIndexV1.readBitmap(dataInput);
        this.trees = PackBitmapIndexV1.readBitmap(dataInput);
        this.blobs = PackBitmapIndexV1.readBitmap(dataInput);
        this.tags = PackBitmapIndexV1.readBitmap(dataInput);
        BasePackBitmapIndex.StoredBitmap[] recentBitmaps = new BasePackBitmapIndex.StoredBitmap[126];
        for (int i = 0; i < (int)numEntries; ++i) {
            int index;
            IO.readFully(fd, scratch, 0, 6);
            int nthObjectId = NB.decodeInt32(scratch, 0);
            byte xorOffset = scratch[4];
            byte flags = scratch[5];
            EWAHCompressedBitmap bitmap = PackBitmapIndexV1.readBitmap(dataInput);
            if (nthObjectId < 0) {
                throw new IOException(MessageFormat.format(JGitText.get().invalidId, String.valueOf(nthObjectId)));
            }
            if (xorOffset < 0) {
                throw new IOException(MessageFormat.format(JGitText.get().invalidId, String.valueOf(xorOffset)));
            }
            if (xorOffset > 126) {
                throw new IOException(MessageFormat.format(JGitText.get().expectedLessThanGot, String.valueOf(126), String.valueOf(xorOffset)));
            }
            if (xorOffset > i) {
                throw new IOException(MessageFormat.format(JGitText.get().expectedLessThanGot, String.valueOf(i), String.valueOf(xorOffset)));
            }
            ObjectId objectId = packIndex.getObjectId(nthObjectId);
            BasePackBitmapIndex.StoredBitmap xorBitmap = null;
            if (xorOffset > 0 && (xorBitmap = recentBitmaps[(index = i - xorOffset) % recentBitmaps.length]) == null) {
                throw new IOException(MessageFormat.format(JGitText.get().invalidId, String.valueOf(xorOffset)));
            }
            BasePackBitmapIndex.StoredBitmap sb = new BasePackBitmapIndex.StoredBitmap(objectId, bitmap, xorBitmap, flags);
            this.bitmaps.add(sb);
            recentBitmaps[i % recentBitmaps.length] = sb;
        }
    }

    @Override
    public int findPosition(AnyObjectId objectId) {
        long offset = this.packIndex.findOffset(objectId);
        if (offset == -1L) {
            return -1;
        }
        return this.reverseIndex.findPostion(offset);
    }

    @Override
    public ObjectId getObject(int position) throws IllegalArgumentException {
        ObjectId objectId = this.reverseIndex.findObjectByPosition(position);
        if (objectId == null) {
            throw new IllegalArgumentException();
        }
        return objectId;
    }

    @Override
    public int getObjectCount() {
        return (int)this.packIndex.getObjectCount();
    }

    @Override
    public EWAHCompressedBitmap ofObjectType(EWAHCompressedBitmap bitmap, int type) {
        switch (type) {
            case 3: {
                return this.blobs.and(bitmap);
            }
            case 2: {
                return this.trees.and(bitmap);
            }
            case 1: {
                return this.commits.and(bitmap);
            }
            case 4: {
                return this.tags.and(bitmap);
            }
        }
        throw new IllegalArgumentException();
    }

    public boolean equals(Object o) {
        if (o instanceof PackBitmapIndexV1) {
            return this.getPackIndex() == ((PackBitmapIndexV1)o).getPackIndex();
        }
        return false;
    }

    public int hashCode() {
        return this.getPackIndex().hashCode();
    }

    PackIndex getPackIndex() {
        return this.packIndex;
    }

    private static EWAHCompressedBitmap readBitmap(DataInput dataInput) throws IOException {
        EWAHCompressedBitmap bitmap = new EWAHCompressedBitmap();
        bitmap.deserialize(dataInput);
        return bitmap;
    }
}

