/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.multimap.impl.client;

import com.hazelcast.multimap.impl.client.MultiMapKeyBasedRequest;
import com.hazelcast.multimap.impl.operations.PutOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.security.permission.MultiMapPermission;
import com.hazelcast.spi.Operation;
import java.io.IOException;
import java.security.Permission;

public class PutRequest
extends MultiMapKeyBasedRequest {
    Data value;
    int index = -1;
    long threadId;

    public PutRequest() {
    }

    public PutRequest(String name, Data key, Data value, int index, long threadId) {
        super(name, key);
        this.value = value;
        this.index = index;
        this.threadId = threadId;
    }

    @Override
    protected Operation prepareOperation() {
        return new PutOperation(this.name, this.key, this.threadId, this.value, this.index);
    }

    @Override
    public int getClassId() {
        return 8;
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        writer.writeInt("i", this.index);
        writer.writeLong("t", this.threadId);
        super.write(writer);
        ObjectDataOutput out = writer.getRawDataOutput();
        out.writeData(this.value);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        this.index = reader.readInt("i");
        this.threadId = reader.readLong("t");
        super.read(reader);
        ObjectDataInput in = reader.getRawDataInput();
        this.value = in.readData();
    }

    @Override
    public Permission getRequiredPermission() {
        return new MultiMapPermission(this.name, "put");
    }

    @Override
    public String getMethodName() {
        return "put";
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{this.key, this.value};
    }
}

