/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.monitor.impl;

import com.hazelcast.com.eclipsesource.json.JsonObject;
import com.hazelcast.memory.MemoryStats;
import com.hazelcast.monitor.LocalGCStats;
import com.hazelcast.monitor.LocalMemoryStats;
import com.hazelcast.monitor.impl.LocalGCStatsImpl;
import com.hazelcast.util.JsonUtil;

public class LocalMemoryStatsImpl
implements LocalMemoryStats {
    private long creationTime;
    private long totalPhysical;
    private long freePhysical;
    private long maxNativeMemory;
    private long committedNativeMemory;
    private long usedNativeMemory;
    private long freeNativeMemory;
    private long maxHeap;
    private long committedHeap;
    private long usedHeap;
    private LocalGCStats gcStats;

    public LocalMemoryStatsImpl() {
    }

    public LocalMemoryStatsImpl(MemoryStats memoryStats) {
        this.setTotalPhysical(memoryStats.getTotalPhysical());
        this.setFreePhysical(memoryStats.getFreePhysical());
        this.setMaxNativeMemory(memoryStats.getMaxNativeMemory());
        this.setCommittedNativeMemory(memoryStats.getCommittedNativeMemory());
        this.setUsedNativeMemory(memoryStats.getUsedNativeMemory());
        this.setFreeNativeMemory(memoryStats.getFreeNativeMemory());
        this.setMaxHeap(memoryStats.getMaxHeap());
        this.setCommittedHeap(memoryStats.getCommittedHeap());
        this.setUsedHeap(memoryStats.getUsedHeap());
        this.setGcStats(new LocalGCStatsImpl(memoryStats.getGCStats()));
    }

    @Override
    public long getTotalPhysical() {
        return this.totalPhysical;
    }

    public void setTotalPhysical(long totalPhysical) {
        this.totalPhysical = totalPhysical;
    }

    @Override
    public long getFreePhysical() {
        return this.freePhysical;
    }

    public void setFreePhysical(long freePhysical) {
        this.freePhysical = freePhysical;
    }

    @Override
    public long getMaxNativeMemory() {
        return this.maxNativeMemory;
    }

    public void setMaxNativeMemory(long maxNativeMemory) {
        this.maxNativeMemory = maxNativeMemory;
    }

    @Override
    public long getCommittedNativeMemory() {
        return this.committedNativeMemory;
    }

    public void setCommittedNativeMemory(long allocated) {
        this.committedNativeMemory = allocated;
    }

    @Override
    public long getUsedNativeMemory() {
        return this.usedNativeMemory;
    }

    public void setUsedNativeMemory(long used) {
        this.usedNativeMemory = used;
    }

    @Override
    public long getFreeNativeMemory() {
        return this.freeNativeMemory;
    }

    public void setFreeNativeMemory(long freeNativeMemory) {
        this.freeNativeMemory = freeNativeMemory;
    }

    @Override
    public long getMaxHeap() {
        return this.maxHeap;
    }

    @Override
    public long getCommittedHeap() {
        return this.committedHeap;
    }

    @Override
    public long getUsedHeap() {
        return this.usedHeap;
    }

    public void setMaxHeap(long maxHeap) {
        this.maxHeap = maxHeap;
    }

    public void setCommittedHeap(long committedHeap) {
        this.committedHeap = committedHeap;
    }

    public void setUsedHeap(long usedHeap) {
        this.usedHeap = usedHeap;
    }

    @Override
    public long getFreeHeap() {
        return this.maxHeap - this.usedHeap;
    }

    @Override
    public LocalGCStats getGCStats() {
        return this.gcStats;
    }

    public void setGcStats(LocalGCStats gcStats) {
        this.gcStats = gcStats;
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public JsonObject toJson() {
        JsonObject root = new JsonObject();
        root.add("creationTime", this.creationTime);
        root.add("totalPhysical", this.totalPhysical);
        root.add("freePhysical", this.freePhysical);
        root.add("maxNativeMemory", this.maxNativeMemory);
        root.add("committedNativeMemory", this.committedNativeMemory);
        root.add("usedNativeMemory", this.usedNativeMemory);
        root.add("freeNativeMemory", this.freeNativeMemory);
        root.add("maxHeap", this.maxHeap);
        root.add("committedHeap", this.committedHeap);
        root.add("usedHeap", this.usedHeap);
        if (this.gcStats == null) {
            this.gcStats = new LocalGCStatsImpl();
        }
        root.add("gcStats", this.gcStats.toJson());
        return root;
    }

    @Override
    public void fromJson(JsonObject json) {
        this.creationTime = JsonUtil.getLong(json, "creationTime", -1L);
        this.totalPhysical = JsonUtil.getLong(json, "totalPhysical", -1L);
        this.freePhysical = JsonUtil.getLong(json, "freePhysical", -1L);
        this.maxNativeMemory = JsonUtil.getLong(json, "maxNativeMemory", -1L);
        this.committedNativeMemory = JsonUtil.getLong(json, "committedNativeMemory", -1L);
        this.usedNativeMemory = JsonUtil.getLong(json, "usedNativeMemory", -1L);
        this.freeNativeMemory = JsonUtil.getLong(json, "freeNativeMemory", -1L);
        this.maxHeap = JsonUtil.getLong(json, "maxHeap", -1L);
        this.committedHeap = JsonUtil.getLong(json, "committedHeap", -1L);
        this.usedHeap = JsonUtil.getLong(json, "usedHeap", -1L);
        this.gcStats = new LocalGCStatsImpl();
        if (json.get("gcStats") != null) {
            this.gcStats.fromJson(JsonUtil.getObject(json, "gcStats"));
        }
    }

    public String toString() {
        return "LocalMemoryStats{totalPhysical=" + this.totalPhysical + ", freePhysical=" + this.freePhysical + ", maxNativeMemory=" + this.maxNativeMemory + ", committedNativeMemory=" + this.committedNativeMemory + ", usedNativeMemory=" + this.usedNativeMemory + ", maxHeap=" + this.maxHeap + ", committedHeap=" + this.committedHeap + ", usedHeap=" + this.usedHeap + ", gcStats=" + this.gcStats + '}';
    }
}

