/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.record;

import com.hazelcast.map.impl.record.RecordStatistics;
import com.hazelcast.map.impl.record.RecordStatisticsImpl;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import java.io.IOException;

public class RecordInfo
implements DataSerializable {
    protected RecordStatistics statistics;
    protected long version;
    protected long evictionCriteriaNumber;
    protected long ttl;
    protected long creationTime;
    protected long lastAccessTime;
    protected long lastUpdateTime;

    public RecordInfo() {
    }

    public RecordInfo(RecordInfo recordInfo) {
        this.statistics = recordInfo.statistics;
        this.version = recordInfo.version;
        this.evictionCriteriaNumber = recordInfo.evictionCriteriaNumber;
        this.ttl = recordInfo.ttl;
        this.creationTime = recordInfo.creationTime;
        this.lastAccessTime = recordInfo.lastAccessTime;
        this.lastUpdateTime = recordInfo.lastUpdateTime;
    }

    public RecordStatistics getStatistics() {
        return this.statistics;
    }

    public void setStatistics(RecordStatistics statistics) {
        this.statistics = statistics;
    }

    public long getVersion() {
        return this.version;
    }

    public void setVersion(long version) {
        this.version = version;
    }

    public long getEvictionCriteriaNumber() {
        return this.evictionCriteriaNumber;
    }

    public void setEvictionCriteriaNumber(long evictionCriteriaNumber) {
        this.evictionCriteriaNumber = evictionCriteriaNumber;
    }

    public long getTtl() {
        return this.ttl;
    }

    public void setTtl(long ttl) {
        this.ttl = ttl;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(long creationTime) {
        this.creationTime = creationTime;
    }

    public long getLastAccessTime() {
        return this.lastAccessTime;
    }

    public void setLastAccessTime(long lastAccessTime) {
        this.lastAccessTime = lastAccessTime;
    }

    public long getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public void setLastUpdateTime(long lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        if (this.statistics != RecordStatistics.EMPTY_STATS) {
            out.writeBoolean(true);
            this.statistics.writeData(out);
        } else {
            out.writeBoolean(false);
        }
        out.writeLong(this.version);
        out.writeLong(this.evictionCriteriaNumber);
        out.writeLong(this.ttl);
        out.writeLong(this.creationTime);
        out.writeLong(this.lastAccessTime);
        out.writeLong(this.lastUpdateTime);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        boolean statsEnabled = in.readBoolean();
        if (statsEnabled) {
            this.statistics = new RecordStatisticsImpl();
            this.statistics.readData(in);
        }
        this.version = in.readLong();
        this.evictionCriteriaNumber = in.readLong();
        this.ttl = in.readLong();
        this.creationTime = in.readLong();
        this.lastAccessTime = in.readLong();
        this.lastUpdateTime = in.readLong();
    }

    public String toString() {
        return "RecordInfo{statistics=" + this.statistics + ", version=" + this.version + ", evictionCriteriaNumber=" + this.evictionCriteriaNumber + ", ttl=" + this.ttl + ", creationTime=" + this.creationTime + ", lastAccessTime=" + this.lastAccessTime + ", lastUpdateTime=" + this.lastUpdateTime + '}';
    }
}

