/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.client;

import com.hazelcast.client.ClientEndpoint;
import com.hazelcast.core.EntryEventType;
import com.hazelcast.map.impl.client.MapAddEntryListenerRequest;
import com.hazelcast.map.impl.nearcache.BatchNearCacheInvalidation;
import com.hazelcast.map.impl.nearcache.Invalidation;
import com.hazelcast.map.impl.nearcache.InvalidationListener;
import com.hazelcast.map.impl.nearcache.NonStopInvalidator;
import com.hazelcast.map.impl.nearcache.SingleNearCacheInvalidation;
import java.util.ArrayList;
import java.util.List;

public class MapAddNearCacheEntryListenerRequest
extends MapAddEntryListenerRequest {
    public MapAddNearCacheEntryListenerRequest() {
    }

    public MapAddNearCacheEntryListenerRequest(String name, boolean includeValue) {
        super(name, includeValue, EntryEventType.INVALIDATION.getType());
    }

    @Override
    public int getClassId() {
        return 50;
    }

    @Override
    protected Object newMapListener(ClientEndpoint endpoint) {
        return new ClientNearCacheInvalidationListenerImpl(this.name, endpoint, this.getCallId());
    }

    private static class ClientNearCacheInvalidationListenerImpl
    implements InvalidationListener {
        private final long callId;
        private final String mapName;
        private final ClientEndpoint endpoint;

        ClientNearCacheInvalidationListenerImpl(String mapName, ClientEndpoint endpoint, long callId) {
            this.mapName = mapName;
            this.endpoint = endpoint;
            this.callId = callId;
        }

        @Override
        public void onInvalidate(Invalidation event) {
            if (!this.endpoint.isAlive()) {
                return;
            }
            event = this.getFilteredEventOrNull(event);
            this.sendEvent(event);
        }

        protected Invalidation getFilteredEventOrNull(Invalidation event) {
            if (event instanceof BatchNearCacheInvalidation) {
                return this.newEventOrNull(event);
            }
            if (!this.endpoint.getUuid().equals(event.getSourceUuid())) {
                return event;
            }
            return null;
        }

        protected BatchNearCacheInvalidation newEventOrNull(Invalidation event) {
            List<SingleNearCacheInvalidation> invalidations = ((BatchNearCacheInvalidation)event).getInvalidations();
            ArrayList<SingleNearCacheInvalidation> newList = null;
            for (SingleNearCacheInvalidation invalidation : invalidations) {
                if (this.endpoint.getUuid().equals(invalidation.getSourceUuid())) continue;
                if (newList == null) {
                    newList = new ArrayList<SingleNearCacheInvalidation>(invalidations.size());
                }
                newList.add(invalidation);
            }
            return newList == null ? null : new BatchNearCacheInvalidation(this.mapName, newList);
        }

        protected void sendEvent(Invalidation event) {
            if (event == null) {
                return;
            }
            Object partitionKey = NonStopInvalidator.getOrderKey(this.mapName, event);
            this.endpoint.sendEvent(partitionKey, event, this.callId);
        }
    }
}

