/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.config.MapIndexConfigReadOnly;
import com.hazelcast.util.Preconditions;

public class MapIndexConfig {
    private String attribute;
    private boolean ordered;
    private MapIndexConfigReadOnly readOnly;

    public MapIndexConfig() {
    }

    public MapIndexConfig(String attribute, boolean ordered) {
        this.setAttribute(attribute);
        this.setOrdered(ordered);
    }

    public MapIndexConfig(MapIndexConfig config) {
        this.attribute = config.getAttribute();
        this.ordered = config.isOrdered();
    }

    public MapIndexConfigReadOnly getAsReadOnly() {
        if (this.readOnly == null) {
            this.readOnly = new MapIndexConfigReadOnly(this);
        }
        return this.readOnly;
    }

    public String getAttribute() {
        return this.attribute;
    }

    public MapIndexConfig setAttribute(String attribute) {
        this.attribute = Preconditions.checkHasText(attribute, "Map index attribute must contain text");
        return this;
    }

    public boolean isOrdered() {
        return this.ordered;
    }

    public MapIndexConfig setOrdered(boolean ordered) {
        this.ordered = ordered;
        return this;
    }

    public String toString() {
        return "MapIndexConfig{attribute='" + this.attribute + "', ordered=" + this.ordered + '}';
    }
}

