/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.concurrent.countdownlatch.client;

import com.hazelcast.client.impl.client.KeyBasedClientRequest;
import com.hazelcast.client.impl.client.SecureRequest;
import com.hazelcast.concurrent.countdownlatch.client.CountDownLatchPortableHook;
import com.hazelcast.concurrent.countdownlatch.operations.AwaitOperation;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.security.permission.CountDownLatchPermission;
import com.hazelcast.spi.Operation;
import java.io.IOException;
import java.security.Permission;
import java.util.concurrent.TimeUnit;

public final class AwaitRequest
extends KeyBasedClientRequest
implements Portable,
SecureRequest {
    private String name;
    private long timeout;

    public AwaitRequest() {
    }

    public AwaitRequest(String name, long timeout) {
        this.name = name;
        this.timeout = timeout;
    }

    @Override
    protected Object getKey() {
        return this.name;
    }

    @Override
    protected Operation prepareOperation() {
        return new AwaitOperation(this.name, this.timeout);
    }

    @Override
    public String getServiceName() {
        return "hz:impl:countDownLatchService";
    }

    @Override
    public int getFactoryId() {
        return CountDownLatchPortableHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 2;
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        writer.writeUTF("name", this.name);
        writer.writeLong("timeout", this.timeout);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        this.name = reader.readUTF("name");
        this.timeout = reader.readLong("timeout");
    }

    @Override
    public Permission getRequiredPermission() {
        return new CountDownLatchPermission(this.name, "read");
    }

    @Override
    public String getDistributedObjectName() {
        return this.name;
    }

    @Override
    public String getMethodName() {
        return "await";
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{this.timeout, TimeUnit.MILLISECONDS};
    }
}

