/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol;

import com.hazelcast.cache.CacheNotExistsException;
import com.hazelcast.client.AuthenticationException;
import com.hazelcast.client.UndefinedErrorCodeException;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ErrorCodec;
import com.hazelcast.client.impl.protocol.exception.MaxMessageSizeExceeded;
import com.hazelcast.cluster.impl.ConfigMismatchException;
import com.hazelcast.config.ConfigurationException;
import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.core.DuplicateInstanceNameException;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.core.HazelcastOverloadException;
import com.hazelcast.core.MemberLeftException;
import com.hazelcast.core.OperationTimeoutException;
import com.hazelcast.map.QueryResultSizeExceededException;
import com.hazelcast.map.ReachedMaxSizeException;
import com.hazelcast.mapreduce.RemoteMapReduceException;
import com.hazelcast.mapreduce.TopologyChangedException;
import com.hazelcast.memory.NativeOutOfMemoryError;
import com.hazelcast.nio.serialization.HazelcastSerializationException;
import com.hazelcast.partition.NoDataMemberInClusterException;
import com.hazelcast.query.QueryException;
import com.hazelcast.quorum.QuorumException;
import com.hazelcast.replicatedmap.ReplicatedMapCantBeCreatedOnLiteMemberException;
import com.hazelcast.ringbuffer.StaleSequenceException;
import com.hazelcast.spi.exception.CallerNotMemberException;
import com.hazelcast.spi.exception.DistributedObjectDestroyedException;
import com.hazelcast.spi.exception.PartitionMigratingException;
import com.hazelcast.spi.exception.ResponseAlreadySentException;
import com.hazelcast.spi.exception.RetryableHazelcastException;
import com.hazelcast.spi.exception.RetryableIOException;
import com.hazelcast.spi.exception.TargetDisconnectedException;
import com.hazelcast.spi.exception.TargetNotMemberException;
import com.hazelcast.spi.exception.WrongTargetException;
import com.hazelcast.topic.TopicOverloadException;
import com.hazelcast.transaction.TransactionException;
import com.hazelcast.transaction.TransactionNotActiveException;
import com.hazelcast.transaction.TransactionTimedOutException;
import com.hazelcast.util.AddressUtil;
import com.hazelcast.wan.WANReplicationQueueFullException;
import java.io.EOFException;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.UTFDataFormatException;
import java.net.SocketException;
import java.net.URISyntaxException;
import java.security.AccessControlException;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeoutException;
import javax.cache.CacheException;
import javax.cache.integration.CacheLoaderException;
import javax.cache.integration.CacheWriterException;
import javax.cache.processor.EntryProcessorException;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.transaction.xa.XAException;

public class ClientExceptionFactory {
    private final Map<Class, Integer> classToInt = new HashMap<Class, Integer>();
    private final Map<Integer, ExceptionFactory> intToFactory = new HashMap<Integer, ExceptionFactory>();

    public ClientExceptionFactory(boolean jcacheAvailable) {
        if (jcacheAvailable) {
            this.register(4, CacheException.class, new ExceptionFactory(){

                @Override
                public Throwable createException(String message, Throwable cause) {
                    return new CacheException(message, cause);
                }
            });
            this.register(5, CacheLoaderException.class, new ExceptionFactory(){

                @Override
                public Throwable createException(String message, Throwable cause) {
                    return new CacheLoaderException(message, cause);
                }
            });
            this.register(7, CacheWriterException.class, new ExceptionFactory(){

                @Override
                public Throwable createException(String message, Throwable cause) {
                    return new CacheWriterException(message, cause);
                }
            });
            this.register(18, EntryProcessorException.class, new ExceptionFactory(){

                @Override
                public Throwable createException(String message, Throwable cause) {
                    return new EntryProcessorException(message, cause);
                }
            });
        }
        this.register(1, ArrayIndexOutOfBoundsException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new ArrayIndexOutOfBoundsException(message);
            }
        });
        this.register(2, ArrayStoreException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new ArrayStoreException(message);
            }
        });
        this.register(3, AuthenticationException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new AuthenticationException(message);
            }
        });
        this.register(6, CacheNotExistsException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new CacheNotExistsException(message);
            }
        });
        this.register(8, CallerNotMemberException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new CallerNotMemberException(message);
            }
        });
        this.register(9, CancellationException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new CancellationException(message);
            }
        });
        this.register(10, ClassCastException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new ClassCastException(message);
            }
        });
        this.register(11, ClassNotFoundException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new ClassNotFoundException(message, cause);
            }
        });
        this.register(12, ConcurrentModificationException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new ConcurrentModificationException(message);
            }
        });
        this.register(13, ConfigMismatchException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new ConfigMismatchException(message);
            }
        });
        this.register(14, ConfigurationException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new ConfigurationException(message);
            }
        });
        this.register(15, DistributedObjectDestroyedException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new DistributedObjectDestroyedException(message);
            }
        });
        this.register(16, DuplicateInstanceNameException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new DuplicateInstanceNameException(message);
            }
        });
        this.register(17, EOFException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new EOFException(message);
            }
        });
        this.register(19, ExecutionException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new ExecutionException(message, cause);
            }
        });
        this.register(20, HazelcastException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new HazelcastException(message, cause);
            }
        });
        this.register(21, HazelcastInstanceNotActiveException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new HazelcastInstanceNotActiveException(message);
            }
        });
        this.register(22, HazelcastOverloadException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new HazelcastOverloadException(message);
            }
        });
        this.register(23, HazelcastSerializationException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new HazelcastSerializationException(message, cause);
            }
        });
        this.register(24, IOException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new IOException(message, cause);
            }
        });
        this.register(25, IllegalArgumentException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new IllegalArgumentException(message, cause);
            }
        });
        this.register(26, IllegalAccessException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new IllegalAccessException(message);
            }
        });
        this.register(27, IllegalAccessError.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new IllegalAccessError(message);
            }
        });
        this.register(28, IllegalMonitorStateException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new IllegalMonitorStateException(message);
            }
        });
        this.register(29, IllegalStateException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new IllegalStateException(message, cause);
            }
        });
        this.register(30, IllegalThreadStateException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new IllegalThreadStateException(message);
            }
        });
        this.register(31, IndexOutOfBoundsException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new IndexOutOfBoundsException(message);
            }
        });
        this.register(32, InterruptedException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new InterruptedException(message);
            }
        });
        this.register(33, AddressUtil.InvalidAddressException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new AddressUtil.InvalidAddressException(message);
            }
        });
        this.register(34, InvalidConfigurationException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new InvalidConfigurationException(message, cause);
            }
        });
        this.register(35, MemberLeftException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new MemberLeftException(message);
            }
        });
        this.register(36, NegativeArraySizeException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new NegativeArraySizeException(message);
            }
        });
        this.register(37, NoSuchElementException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new NoSuchElementException(message);
            }
        });
        this.register(38, NotSerializableException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new NotSerializableException(message);
            }
        });
        this.register(39, NullPointerException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new NullPointerException(message);
            }
        });
        this.register(40, OperationTimeoutException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new OperationTimeoutException(message);
            }
        });
        this.register(41, PartitionMigratingException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new PartitionMigratingException(message);
            }
        });
        this.register(42, QueryException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new QueryException(message, cause);
            }
        });
        this.register(43, QueryResultSizeExceededException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new QueryResultSizeExceededException(message);
            }
        });
        this.register(44, QuorumException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new QuorumException(message);
            }
        });
        this.register(45, ReachedMaxSizeException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new ReachedMaxSizeException(message);
            }
        });
        this.register(46, RejectedExecutionException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new RejectedExecutionException(message, cause);
            }
        });
        this.register(47, RemoteMapReduceException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new RemoteMapReduceException(message, Collections.<Exception>emptyList());
            }
        });
        this.register(48, ResponseAlreadySentException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new ResponseAlreadySentException(message);
            }
        });
        this.register(49, RetryableHazelcastException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new RetryableHazelcastException(message, cause);
            }
        });
        this.register(50, RetryableIOException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new RetryableIOException(message, cause);
            }
        });
        this.register(51, RuntimeException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new RuntimeException(message, cause);
            }
        });
        this.register(52, SecurityException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new SecurityException(message, cause);
            }
        });
        this.register(53, SocketException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new SocketException(message);
            }
        });
        this.register(54, StaleSequenceException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new StaleSequenceException(message, 0L);
            }
        });
        this.register(55, TargetDisconnectedException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new TargetDisconnectedException(message);
            }
        });
        this.register(56, TargetNotMemberException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new TargetNotMemberException(message);
            }
        });
        this.register(57, TimeoutException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new TimeoutException(message);
            }
        });
        this.register(58, TopicOverloadException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new TopicOverloadException(message);
            }
        });
        this.register(59, TopologyChangedException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new TopologyChangedException(message);
            }
        });
        this.register(60, TransactionException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new TransactionException(message, cause);
            }
        });
        this.register(61, TransactionNotActiveException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new TransactionNotActiveException(message);
            }
        });
        this.register(62, TransactionTimedOutException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new TransactionTimedOutException(message, cause);
            }
        });
        this.register(63, URISyntaxException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new URISyntaxException("not available", message);
            }
        });
        this.register(64, UTFDataFormatException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new UTFDataFormatException(message);
            }
        });
        this.register(65, UnsupportedOperationException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new UnsupportedOperationException(message, cause);
            }
        });
        this.register(66, WrongTargetException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new WrongTargetException(message);
            }
        });
        this.register(67, XAException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new XAException(message);
            }
        });
        this.register(68, AccessControlException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new AccessControlException(message);
            }
        });
        this.register(69, LoginException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new LoginException(message);
            }
        });
        this.register(70, UnsupportedCallbackException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new UnsupportedCallbackException(null, message);
            }
        });
        this.register(71, NoDataMemberInClusterException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new NoDataMemberInClusterException(message);
            }
        });
        this.register(72, ReplicatedMapCantBeCreatedOnLiteMemberException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new ReplicatedMapCantBeCreatedOnLiteMemberException(message);
            }
        });
        this.register(73, MaxMessageSizeExceeded.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new MaxMessageSizeExceeded();
            }
        });
        this.register(74, WANReplicationQueueFullException.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new WANReplicationQueueFullException(message);
            }
        });
        this.register(75, AssertionError.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new AssertionError((Object)message);
            }
        });
        this.register(76, OutOfMemoryError.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new OutOfMemoryError(message);
            }
        });
        this.register(77, StackOverflowError.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new StackOverflowError(message);
            }
        });
        this.register(78, NativeOutOfMemoryError.class, new ExceptionFactory(){

            @Override
            public Throwable createException(String message, Throwable cause) {
                return new NativeOutOfMemoryError(message, cause);
            }
        });
    }

    public Throwable createException(ClientMessage clientMessage) {
        ErrorCodec parameters = ErrorCodec.decode(clientMessage);
        Throwable cause = null;
        if (parameters.causeClassName != null) {
            cause = this.createException(parameters.causeErrorCode, parameters.causeClassName, null, null);
        }
        Throwable throwable = this.createException(parameters.errorCode, parameters.className, parameters.message, cause);
        throwable.setStackTrace(parameters.stackTrace);
        return throwable;
    }

    public ClientMessage createExceptionMessage(Throwable throwable) {
        int errorCode = this.getErrorCode(throwable);
        String message = throwable.getMessage();
        StackTraceElement[] stackTrace = throwable.getStackTrace();
        Throwable cause = throwable.getCause();
        boolean hasCause = cause != null;
        String className = throwable.getClass().getName();
        if (hasCause) {
            int causeErrorCode = this.getErrorCode(cause);
            String causeClassName = cause.getClass().getName();
            return ErrorCodec.encode(errorCode, className, message, stackTrace, causeErrorCode, causeClassName);
        }
        return ErrorCodec.encode(errorCode, className, message, stackTrace, 0, null);
    }

    private Throwable createException(int errorCode, String className, String message, Throwable cause) {
        ExceptionFactory exceptionFactory = this.intToFactory.get(errorCode);
        Throwable throwable = exceptionFactory == null ? new UndefinedErrorCodeException(message, className) : exceptionFactory.createException(message, cause);
        return throwable;
    }

    private void register(int errorCode, Class clazz, ExceptionFactory exceptionFactory) {
        this.classToInt.put(clazz, errorCode);
        this.intToFactory.put(errorCode, exceptionFactory);
    }

    private int getErrorCode(Throwable e) {
        Integer errorCode = this.classToInt.get(e.getClass());
        if (errorCode == null) {
            return 0;
        }
        return errorCode;
    }

    static interface ExceptionFactory {
        public Throwable createException(String var1, Throwable var2);
    }
}

