/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.compiler;

import com.android.builder.core.AndroidBuilder;
import com.android.builder.core.DexOptions;
import com.android.builder.internal.compiler.DexKey;
import com.android.builder.internal.compiler.PreProcessCache;
import com.android.ide.common.process.ProcessException;
import com.android.ide.common.process.ProcessOutputHandler;
import com.android.repository.Revision;
import com.android.utils.FileUtils;
import com.android.utils.Pair;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.logging.Logger;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class PreDexCache
extends PreProcessCache<DexKey> {
    private static final String ATTR_JUMBO_MODE = "jumboMode";
    private static final PreDexCache sSingleton = new PreDexCache();

    public static PreDexCache getCache() {
        return sSingleton;
    }

    @Override
    protected PreProcessCache.KeyFactory<DexKey> getKeyFactory() {
        return new PreProcessCache.KeyFactory<DexKey>(){

            @Override
            public DexKey of(File sourceFile, Revision revision, NamedNodeMap attrMap) {
                return DexKey.of(sourceFile, revision, Boolean.parseBoolean(attrMap.getNamedItem(PreDexCache.ATTR_JUMBO_MODE).getNodeValue()));
            }
        };
    }

    public void preDexLibrary(AndroidBuilder builder, File inputFile, File outFile, boolean multiDex, DexOptions dexOptions, ProcessOutputHandler processOutputHandler) throws IOException, ProcessException, InterruptedException {
        Preconditions.checkState((!multiDex || outFile.isDirectory() ? 1 : 0) != 0);
        Preconditions.checkState((builder.getTargetInfo() != null ? 1 : 0) != 0);
        DexKey itemKey = DexKey.of(inputFile, builder.getTargetInfo().getBuildTools().getRevision(), dexOptions.getJumboMode());
        Pair<PreProcessCache.Item, Boolean> pair = this.getItem(itemKey);
        PreProcessCache.Item item = (PreProcessCache.Item)pair.getFirst();
        if (((Boolean)pair.getSecond()).booleanValue()) {
            try {
                ImmutableList<File> files = builder.preDexLibraryNoCache(inputFile, outFile, multiDex, dexOptions, processOutputHandler);
                item.getOutputFiles().clear();
                item.getOutputFiles().addAll((Collection<File>)files);
                this.incrementMisses();
            }
            catch (ProcessException exception) {
                FileUtils.deleteIfExists((File)outFile);
                throw exception;
            }
            finally {
                item.getLatch().countDown();
            }
        } else {
            item.getLatch().await();
            if (item.areOutputFilesPresent()) {
                if (multiDex) {
                    for (File sourceFile : item.getOutputFiles()) {
                        File destFile = new File(outFile, sourceFile.getName());
                        PreDexCache.checkSame(sourceFile, destFile);
                        Files.copy((File)sourceFile, (File)destFile);
                    }
                } else {
                    if (item.getOutputFiles().isEmpty()) {
                        throw new RuntimeException(item.toString());
                    }
                    PreDexCache.checkSame(item.getOutputFiles().get(0), outFile);
                    Files.copy((File)item.getOutputFiles().get(0), (File)outFile);
                }
                this.incrementHits();
            }
        }
    }

    @Override
    protected Node createItemNode(Document document, DexKey itemKey, PreProcessCache.BaseItem item) throws IOException {
        Node itemNode = super.createItemNode(document, itemKey, item);
        if (itemNode != null) {
            Attr attr = document.createAttribute(ATTR_JUMBO_MODE);
            attr.setValue(Boolean.toString(itemKey.isJumboMode()));
            itemNode.getAttributes().setNamedItem(attr);
        }
        return itemNode;
    }

    private static void checkSame(File source, File dest) {
        if (source.equals(dest)) {
            Logger.getAnonymousLogger().info(String.format("%s l:%d ts:%d", source, source.length(), source.lastModified()));
        }
    }
}

