/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.testing.AbstractCollectionTestSuiteBuilder;
import com.google.common.collect.testing.AbstractTester;
import com.google.common.collect.testing.FeatureSpecificTestSuiteBuilder;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.OneSizeTestContainerGenerator;
import com.google.common.collect.testing.SampleElements;
import com.google.common.collect.testing.TestSetGenerator;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.Feature;
import com.google.common.collect.testing.testers.CollectionSerializationEqualTester;
import com.google.common.collect.testing.testers.SetAddAllTester;
import com.google.common.collect.testing.testers.SetAddTester;
import com.google.common.collect.testing.testers.SetCreationTester;
import com.google.common.collect.testing.testers.SetEqualsTester;
import com.google.common.collect.testing.testers.SetHashCodeTester;
import com.google.common.collect.testing.testers.SetRemoveTester;
import com.google.common.testing.SerializableTester;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import junit.framework.TestSuite;

@GwtIncompatible
public class SetTestSuiteBuilder<E>
extends AbstractCollectionTestSuiteBuilder<SetTestSuiteBuilder<E>, E> {
    public static <E> SetTestSuiteBuilder<E> using(TestSetGenerator<E> generator) {
        return (SetTestSuiteBuilder)new SetTestSuiteBuilder<E>().usingGenerator(generator);
    }

    @Override
    protected List<Class<? extends AbstractTester>> getTesters() {
        List<Class<? extends AbstractTester>> testers = Helpers.copyToList(super.getTesters());
        testers.add(CollectionSerializationEqualTester.class);
        testers.add(SetAddAllTester.class);
        testers.add(SetAddTester.class);
        testers.add(SetCreationTester.class);
        testers.add(SetHashCodeTester.class);
        testers.add(SetEqualsTester.class);
        testers.add(SetRemoveTester.class);
        return testers;
    }

    @Override
    protected List<TestSuite> createDerivedSuites(FeatureSpecificTestSuiteBuilder<?, ? extends OneSizeTestContainerGenerator<Collection<E>, E>> parentBuilder) {
        ArrayList<TestSuite> derivedSuites = new ArrayList<TestSuite>(super.createDerivedSuites(parentBuilder));
        if (parentBuilder.getFeatures().contains(CollectionFeature.SERIALIZABLE)) {
            derivedSuites.add(((SetTestSuiteBuilder)((SetTestSuiteBuilder)((SetTestSuiteBuilder)SetTestSuiteBuilder.using(new ReserializedSetGenerator(parentBuilder.getSubjectGenerator())).named(this.getName() + " reserialized")).withFeatures(SetTestSuiteBuilder.computeReserializedCollectionFeatures(parentBuilder.getFeatures()))).suppressing(parentBuilder.getSuppressedTests())).createTestSuite());
        }
        return derivedSuites;
    }

    private static Set<Feature<?>> computeReserializedCollectionFeatures(Set<Feature<?>> features) {
        HashSet derivedFeatures = new HashSet();
        derivedFeatures.addAll(features);
        derivedFeatures.remove(CollectionFeature.SERIALIZABLE);
        derivedFeatures.remove(CollectionFeature.SERIALIZABLE_INCLUDING_VIEWS);
        return derivedFeatures;
    }

    static class ReserializedSetGenerator<E>
    implements TestSetGenerator<E> {
        final OneSizeTestContainerGenerator<Collection<E>, E> gen;

        private ReserializedSetGenerator(OneSizeTestContainerGenerator<Collection<E>, E> gen) {
            this.gen = gen;
        }

        @Override
        public SampleElements<E> samples() {
            return this.gen.samples();
        }

        @Override
        public Set<E> create(Object ... elements) {
            return (Set)SerializableTester.reserialize(this.gen.create(elements));
        }

        @Override
        public E[] createArray(int length) {
            return this.gen.createArray(length);
        }

        @Override
        public Iterable<E> order(List<E> insertionOrder) {
            return this.gen.order(insertionOrder);
        }
    }
}

