/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.collectionincompatibletype;

import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.collectionincompatibletype.AutoValue_AbstractCollectionIncompatibleTypeMatcher_MatchResult;
import com.google.errorprone.matchers.Matcher;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.util.List;
import javax.annotation.Nullable;

abstract class AbstractCollectionIncompatibleTypeMatcher {
    AbstractCollectionIncompatibleTypeMatcher() {
    }

    abstract Matcher<ExpressionTree> methodMatcher();

    @Nullable
    abstract Type extractSourceType(MethodInvocationTree var1, VisitorState var2);

    @Nullable
    abstract ExpressionTree extractSourceTree(MethodInvocationTree var1, VisitorState var2);

    @Nullable
    abstract Type extractTargetType(MethodInvocationTree var1, VisitorState var2);

    @Nullable
    public final MatchResult matches(MethodInvocationTree tree, VisitorState state) {
        if (!this.methodMatcher().matches((Tree)tree, state)) {
            return null;
        }
        ExpressionTree sourceTree = this.extractSourceTree(tree, state);
        Type sourceType = this.extractSourceType(tree, state);
        Type targetType = this.extractTargetType(tree, state);
        if (sourceTree == null || sourceType == null || targetType == null) {
            return null;
        }
        return MatchResult.create(this.extractSourceTree(tree, state), this.extractSourceType(tree, state), this.extractTargetType(tree, state), this);
    }

    @Nullable
    protected static final Type extractTypeArgAsMemberOfSupertype(Type type, Symbol superTypeSym, int typeArgIndex, Types types) {
        Type collectionType = types.asSuper(type, superTypeSym);
        if (collectionType == null) {
            return null;
        }
        List<Type> tyargs = collectionType.getTypeArguments();
        if (tyargs.size() <= typeArgIndex) {
            return null;
        }
        return tyargs.get(typeArgIndex);
    }

    static abstract class MatchResult {
        MatchResult() {
        }

        public abstract ExpressionTree sourceTree();

        public abstract Type sourceType();

        public abstract Type targetType();

        public abstract AbstractCollectionIncompatibleTypeMatcher matcher();

        public static MatchResult create(ExpressionTree sourceTree, Type sourceType, Type targetType, AbstractCollectionIncompatibleTypeMatcher matcher) {
            return new AutoValue_AbstractCollectionIncompatibleTypeMatcher_MatchResult(sourceTree, sourceType, targetType, matcher);
        }
    }
}

