/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.tree.JCTree;

@BugPattern(name="ProtoFieldPreconditionsCheckNotNull", summary="Protobuf fields cannot be null, so this check is redundant", explanation="This checker looks for comparisons of protocol buffer fields with null via the com.google.common.base.Preconditions.checkNotNull method. If a proto field is not specified, its field accessor will return a non-null default value. Thus, the result of calling one of these accessors can never be null, and comparisons like these often indicate a nearby error.\n\nIf you meant to check whether an optional field has been set, you should use the hasField() method instead.", category=BugPattern.Category.GUAVA, severity=BugPattern.SeverityLevel.WARNING, tags={"LikelyError"})
public class ProtoFieldPreconditionsCheckNotNull
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final String PROTO_SUPER_CLASS = "com.google.protobuf.GeneratedMessage";
    private static final Matcher<ExpressionTree> protoMessageReceiverMatcher = Matchers.instanceMethod().onDescendantOf("com.google.protobuf.GeneratedMessage");
    private static final String LIST_INTERFACE = "java.util.List";
    private static final Matcher<Tree> returnsListMatcher = Matchers.isSubtypeOf((String)"java.util.List");
    private static final Matcher<ExpressionTree> PROTO_MESSAGE_INVOCATION_MATCHER = new Matcher<ExpressionTree>(){

        public boolean matches(ExpressionTree tree, VisitorState state) {
            return ProtoFieldPreconditionsCheckNotNull.isProtoMessageGetInvocation(tree, state);
        }
    };
    private static final Matcher<MethodInvocationTree> CHECK_NOT_NULL_MATCHER = Matchers.allOf((Matcher[])new Matcher[]{Matchers.staticMethod().onClass("com.google.common.base.Preconditions").named("checkNotNull"), Matchers.argument((int)0, (Matcher)Matchers.allOf((Matcher[])new Matcher[]{Matchers.kindIs((Tree.Kind)Tree.Kind.METHOD_INVOCATION), PROTO_MESSAGE_INVOCATION_MATCHER}))});

    private static boolean isProtoMessageGetInvocation(ExpressionTree tree, VisitorState state) {
        return (ProtoFieldPreconditionsCheckNotNull.isGetMethodInvocation(tree, state) || ProtoFieldPreconditionsCheckNotNull.isGetListMethodInvocation(tree, state)) && ProtoFieldPreconditionsCheckNotNull.receiverIsProtoMessage(tree, state);
    }

    private static boolean isFieldGetMethod(String methodName) {
        return methodName.startsWith("get");
    }

    private static boolean isGetListMethodInvocation(ExpressionTree tree, VisitorState state) {
        if (tree.getKind() == Tree.Kind.METHOD_INVOCATION) {
            MethodInvocationTree method = (MethodInvocationTree)tree;
            if (!method.getArguments().isEmpty()) {
                return false;
            }
            if (!returnsListMatcher.matches((Tree)method, state)) {
                return false;
            }
            ExpressionTree expressionTree = method.getMethodSelect();
            if (expressionTree instanceof JCTree.JCFieldAccess) {
                JCTree.JCFieldAccess access = (JCTree.JCFieldAccess)expressionTree;
                String methodName = access.sym.getQualifiedName().toString();
                return ProtoFieldPreconditionsCheckNotNull.isFieldGetMethod(methodName);
            }
            return true;
        }
        return false;
    }

    private static boolean isGetMethodInvocation(ExpressionTree tree, VisitorState state) {
        if (tree.getKind() == Tree.Kind.METHOD_INVOCATION) {
            MethodInvocationTree method = (MethodInvocationTree)tree;
            if (!method.getArguments().isEmpty()) {
                return false;
            }
            if (returnsListMatcher.matches((Tree)method, state)) {
                return false;
            }
            ExpressionTree expressionTree = method.getMethodSelect();
            if (expressionTree instanceof JCTree.JCFieldAccess) {
                JCTree.JCFieldAccess access = (JCTree.JCFieldAccess)expressionTree;
                String methodName = access.sym.getQualifiedName().toString();
                return ProtoFieldPreconditionsCheckNotNull.isFieldGetMethod(methodName);
            }
            return true;
        }
        return false;
    }

    private static boolean receiverIsProtoMessage(ExpressionTree tree, VisitorState state) {
        return protoMessageReceiverMatcher.matches((Tree)((MethodInvocationTree)tree), state);
    }

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!CHECK_NOT_NULL_MATCHER.matches((Tree)tree, state) || tree.getArguments().isEmpty()) {
            return Description.NO_MATCH;
        }
        SuggestedFix fix = Matchers.parentNode((Matcher)Matchers.kindIs((Tree.Kind)Tree.Kind.EXPRESSION_STATEMENT)).matches((Tree)tree, state) ? SuggestedFix.delete((Tree)state.getPath().getParentPath().getLeaf()) : SuggestedFix.replace((Tree)tree, (String)tree.getArguments().get(0).toString());
        return this.describeMatch(tree, (Fix)fix);
    }
}

