/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.CanBeStaticAnalyzer;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;

@BugPattern(name="ClassCanBeStatic", summary="Inner class is non-static but does not reference enclosing class", explanation="An inner class should be static unless it references members of its enclosing class. An inner class that is made non-static unnecessarily uses more memory and does not make the intent of the class clear.", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.WARNING, tags={"Style", "Performance"})
public class ClassCanBeStatic
extends BugChecker
implements BugChecker.ClassTreeMatcher {
    public Description matchClass(ClassTree tree, VisitorState state) {
        Symbol.ClassSymbol currentClass = ASTHelpers.getSymbol((ClassTree)tree);
        if (currentClass == null || !currentClass.hasOuterInstance()) {
            return Description.NO_MATCH;
        }
        if (currentClass.getNestingKind() != NestingKind.MEMBER) {
            return Description.NO_MATCH;
        }
        switch (currentClass.owner.enclClass().getNestingKind()) {
            case TOP_LEVEL: {
                break;
            }
            case MEMBER: {
                if (!currentClass.owner.enclClass().hasOuterInstance()) break;
                return Description.NO_MATCH;
            }
            case LOCAL: 
            case ANONYMOUS: {
                return Description.NO_MATCH;
            }
        }
        if (tree.getExtendsClause() != null && ASTHelpers.getType((Tree)tree.getExtendsClause()).tsym.hasOuterInstance()) {
            return Description.NO_MATCH;
        }
        if (CanBeStaticAnalyzer.referencesOuter(tree, currentClass, state)) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(tree, (Fix)SuggestedFixes.addModifiers((Tree)tree, (VisitorState)state, (Modifier[])new Modifier[]{Modifier.STATIC}));
    }
}

