/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.util.concurrent.AsyncCallable;
import com.google.errorprone.BugPattern;
import com.google.errorprone.bugpatterns.AbstractAsyncTypeReturnsNull;

@BugPattern(name="AsyncCallableReturnsNull", summary="AsyncCallable should not return a null Future, only a Future whose result is null.", explanation="Methods like Futures.whenAllComplete(...).callAsync(...) will throw a NullPointerException if the provided AsyncCallable returns a null Future. To produce a Future with an output of null, instead return immediateFuture(null).", category=BugPattern.Category.GUAVA, severity=BugPattern.SeverityLevel.ERROR)
public final class AsyncCallableReturnsNull
extends AbstractAsyncTypeReturnsNull {
    public AsyncCallableReturnsNull() {
        super(AsyncCallable.class);
    }
}

