/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.names;

import blogspot.software_and_algorithms.stern_library.optimization.HungarianAlgorithm;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.names.LevenshteinEditDistance;
import com.google.errorprone.names.NamingConventions;
import java.util.function.BiFunction;
import java.util.stream.DoubleStream;

public class TermEditDistance {
    private final BiFunction<String, String, Double> editDistanceFn;
    private final BiFunction<Integer, Integer, Double> maxDistanceFn;

    public TermEditDistance(BiFunction<String, String, Double> editDistanceFn, BiFunction<Integer, Integer, Double> maxDistanceFn) {
        this.editDistanceFn = editDistanceFn;
        this.maxDistanceFn = maxDistanceFn;
    }

    public TermEditDistance() {
        this((s, t) -> LevenshteinEditDistance.getEditDistance(s, t, false), (s, t) -> LevenshteinEditDistance.getWorstCaseEditDistance(s, t));
    }

    public double getNormalizedEditDistance(String source, String target) {
        ImmutableList<String> sourceTerms = NamingConventions.splitToLowercaseTerms(source);
        ImmutableList<String> targetTerms = NamingConventions.splitToLowercaseTerms(target);
        double[][] costMatrix = (double[][])sourceTerms.stream().map(s -> targetTerms.stream().mapToDouble(t -> this.editDistanceFn.apply((String)s, (String)t)).toArray()).toArray(x$0 -> new double[x$0][]);
        double[][] worstCaseMatrix = (double[][])sourceTerms.stream().map(s -> s.length()).map(s -> targetTerms.stream().map(t -> t.length()).mapToDouble(t -> this.maxDistanceFn.apply((Integer)s, (Integer)t)).toArray()).toArray(x$0 -> new double[x$0][]);
        double[] sourceTermDeletionCosts = sourceTerms.stream().mapToDouble(s -> this.maxDistanceFn.apply(s.length(), 0)).toArray();
        double[] targetTermAdditionCosts = targetTerms.stream().mapToDouble(s -> this.maxDistanceFn.apply(0, s.length())).toArray();
        int[] assignments = new HungarianAlgorithm(costMatrix).execute();
        double assignmentCost = TermEditDistance.computeCost(assignments, costMatrix, sourceTermDeletionCosts, targetTermAdditionCosts);
        double maxCost = TermEditDistance.computeCost(assignments, worstCaseMatrix, sourceTermDeletionCosts, targetTermAdditionCosts);
        return assignmentCost / maxCost;
    }

    private static double computeCost(int[] assignments, double[][] costMatrix, double[] sourceTermDeletionCosts, double[] targetTermDeletionCosts) {
        double totalCost = DoubleStream.of(targetTermDeletionCosts).sum();
        for (int sourceTermIndex = 0; sourceTermIndex < assignments.length; ++sourceTermIndex) {
            int targetTermIndex = assignments[sourceTermIndex];
            if (targetTermIndex == -1) {
                totalCost += sourceTermDeletionCosts[sourceTermIndex];
                continue;
            }
            totalCost += costMatrix[sourceTermIndex][targetTermIndex];
            totalCost -= targetTermDeletionCosts[targetTermIndex];
        }
        return totalCost;
    }
}

