/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.dataflow.nullnesspropagation;

import com.google.common.base.Predicate;
import com.google.errorprone.dataflow.LocalStore;
import com.google.errorprone.dataflow.nullnesspropagation.MethodInfo;
import com.google.errorprone.dataflow.nullnesspropagation.Nullness;
import com.google.errorprone.dataflow.nullnesspropagation.NullnessPropagationTransfer;
import java.util.List;
import javax.annotation.Nullable;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import org.checkerframework.dataflow.cfg.UnderlyingAST;
import org.checkerframework.dataflow.cfg.node.LocalVariableNode;

class TrustingNullnessPropagation
extends NullnessPropagationTransfer {
    private static final long serialVersionUID = -3128676755493202966L;

    TrustingNullnessPropagation() {
        super(Nullness.NONNULL, TrustReturnAnnotation.INSTANCE);
    }

    @Override
    public LocalStore<Nullness> initialStore(UnderlyingAST underlyingAST, List<LocalVariableNode> parameters) {
        if (parameters == null) {
            return LocalStore.empty();
        }
        LocalStore.Builder<Nullness> result = LocalStore.empty().toBuilder();
        for (LocalVariableNode param : parameters) {
            Element element = param.getElement();
            Nullness assumed = TrustingNullnessPropagation.nullnessFromAnnotations(element);
            result.setInformation(element, assumed);
        }
        return result.build();
    }

    @Override
    Nullness fieldNullness(@Nullable NullnessPropagationTransfer.ClassAndField accessed) {
        if (accessed == null) {
            return Nullness.NONNULL;
        }
        return TrustingNullnessPropagation.nullnessFromAnnotations(accessed.symbol);
    }

    static Nullness nullnessFromAnnotations(Element element) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!annotationMirror.getAnnotationType().toString().endsWith(".Nullable")) continue;
            return Nullness.NULLABLE;
        }
        return Nullness.NONNULL;
    }

    private static enum TrustReturnAnnotation implements Predicate<MethodInfo>
    {
        INSTANCE;


        public boolean apply(MethodInfo input) {
            for (String annotation : input.annotations()) {
                if (!annotation.endsWith(".Nullable")) continue;
                return false;
            }
            return true;
        }
    }
}

