/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import com.android.tools.lint.detector.api.XmlContext;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class UseCompoundDrawableDetector
extends LayoutDetector {
    public static final Issue ISSUE = Issue.create((String)"UseCompoundDrawables", (String)"Node can be replaced by a `TextView` with compound drawables", (String)"A `LinearLayout` which contains an `ImageView` and a `TextView` can be more efficiently handled as a compound drawable (a single TextView, using the `drawableTop`, `drawableLeft`, `drawableRight` and/or `drawableBottom` attributes to draw one or more images adjacent to the text).\n\nIf the two widgets are offset from each other with margins, this can be replaced with a `drawablePadding` attribute.\n\nThere's a lint quickfix to perform this conversion in the Eclipse plugin.", (Category)Category.PERFORMANCE, (int)6, (Severity)Severity.WARNING, (Implementation)new Implementation(UseCompoundDrawableDetector.class, Scope.RESOURCE_FILE_SCOPE));

    public Speed getSpeed() {
        return Speed.FAST;
    }

    public Collection<String> getApplicableElements() {
        return Collections.singletonList("LinearLayout");
    }

    public void visitElement(XmlContext context, Element element) {
        int childCount = LintUtils.getChildCount((Node)element);
        if (childCount == 2) {
            List children = LintUtils.getChildren((Node)element);
            Element first = (Element)children.get(0);
            Element second = (Element)children.get(1);
            if (first.getTagName().equals("ImageView") && second.getTagName().equals("TextView") && !first.hasAttributeNS("http://schemas.android.com/apk/res/android", "layout_weight") || second.getTagName().equals("ImageView") && first.getTagName().equals("TextView") && !second.hasAttributeNS("http://schemas.android.com/apk/res/android", "layout_weight")) {
                String scaleType;
                if (element.hasAttributeNS("http://schemas.android.com/apk/res/android", "background")) {
                    return;
                }
                String string = scaleType = first.getTagName().equals("ImageView") ? first.getAttributeNS("http://schemas.android.com/apk/res/android", "scaleType") : second.getAttributeNS("http://schemas.android.com/apk/res/android", "scaleType");
                if (scaleType != null && !scaleType.isEmpty()) {
                    return;
                }
                context.report(ISSUE, (Node)element, context.getLocation((Node)element), "This tag and its children can be replaced by one `<TextView/>` and a compound drawable");
            }
        }
    }
}

