/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.JavaParser;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import java.util.Collections;
import java.util.List;
import lombok.ast.ClassDeclaration;
import lombok.ast.Node;

public class ParcelDetector
extends Detector
implements Detector.JavaScanner {
    public static final Issue ISSUE = Issue.create((String)"ParcelCreator", (String)"Missing Parcelable `CREATOR` field", (String)"According to the `Parcelable` interface documentation, \"Classes implementing the Parcelable interface must also have a static field called `CREATOR`, which is an object implementing the `Parcelable.Creator` interface.\"", (Category)Category.CORRECTNESS, (int)3, (Severity)Severity.ERROR, (Implementation)new Implementation(ParcelDetector.class, Scope.JAVA_FILE_SCOPE)).addMoreInfo("http://developer.android.com/reference/android/os/Parcelable.html");

    public List<String> applicableSuperClasses() {
        return Collections.singletonList("android.os.Parcelable");
    }

    public void checkClass(JavaContext context, ClassDeclaration node, Node declarationOrAnonymous, JavaParser.ResolvedClass cls) {
        JavaParser.ResolvedField field;
        if (node == null) {
            return;
        }
        int flags = node.astModifiers().getExplicitModifierFlags();
        if ((flags & 0x600) != 0) {
            return;
        }
        if (!cls.isImplementing("android.text.ParcelableSpan", false) && (field = cls.getField("CREATOR", false)) == null) {
            Location location = context.getLocation((Node)node.astName());
            context.report(ISSUE, (Node)node, location, "This class implements `Parcelable` but does not provide a `CREATOR` field");
        }
    }
}

