/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.bytecode;

import com.google.common.collect.ImmutableList;
import com.google.turbine.model.Const;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ConstantPool {
    int nextEntry = 1;
    private final Map<String, Integer> utf8Pool = new HashMap<String, Integer>();
    private final Map<Integer, Integer> classInfoPool = new HashMap<Integer, Integer>();
    private final Map<Integer, Integer> stringPool = new HashMap<Integer, Integer>();
    private final Map<Integer, Integer> integerPool = new HashMap<Integer, Integer>();
    private final Map<Double, Integer> doublePool = new HashMap<Double, Integer>();
    private final Map<Float, Integer> floatPool = new HashMap<Float, Integer>();
    private final Map<Long, Integer> longPool = new HashMap<Long, Integer>();
    private final List<Entry> constants = new ArrayList<Entry>();

    public ImmutableList<Entry> constants() {
        return ImmutableList.copyOf(this.constants);
    }

    private static short width(Kind kind) {
        switch (kind) {
            case CLASS_INFO: 
            case STRING: 
            case INTEGER: 
            case UTF8: 
            case FLOAT: {
                return 1;
            }
            case LONG: 
            case DOUBLE: {
                return 2;
            }
        }
        throw new AssertionError((Object)kind);
    }

    int classInfo(String value) {
        Objects.requireNonNull(value);
        int utf8 = this.utf8(value);
        if (this.classInfoPool.containsKey(utf8)) {
            return this.classInfoPool.get(utf8);
        }
        int index = this.insert(new Entry(Kind.CLASS_INFO, new Const.IntValue(utf8)));
        this.classInfoPool.put(utf8, index);
        return index;
    }

    int utf8(String value) {
        Objects.requireNonNull(value);
        if (this.utf8Pool.containsKey(value)) {
            return this.utf8Pool.get(value);
        }
        int index = this.insert(new Entry(Kind.UTF8, new Const.StringValue(value)));
        this.utf8Pool.put(value, index);
        return index;
    }

    int integer(int value) {
        if (this.integerPool.containsKey(value)) {
            return this.integerPool.get(value);
        }
        int index = this.insert(new Entry(Kind.INTEGER, new Const.IntValue(value)));
        this.integerPool.put(value, index);
        return index;
    }

    int longInfo(long value) {
        if (this.longPool.containsKey(value)) {
            return this.longPool.get(value);
        }
        int index = this.insert(new Entry(Kind.LONG, new Const.LongValue(value)));
        this.longPool.put(value, index);
        return index;
    }

    int doubleInfo(double value) {
        if (this.doublePool.containsKey(value)) {
            return this.doublePool.get(value);
        }
        int index = this.insert(new Entry(Kind.DOUBLE, new Const.DoubleValue(value)));
        this.doublePool.put(value, index);
        return index;
    }

    int floatInfo(float value) {
        if (this.floatPool.containsKey(Float.valueOf(value))) {
            return this.floatPool.get(Float.valueOf(value));
        }
        int index = this.insert(new Entry(Kind.FLOAT, new Const.FloatValue(value)));
        this.floatPool.put(Float.valueOf(value), index);
        return index;
    }

    int string(String value) {
        Objects.requireNonNull(value);
        int utf8 = this.utf8(value);
        if (this.stringPool.containsKey(utf8)) {
            return this.stringPool.get(utf8);
        }
        int index = this.insert(new Entry(Kind.STRING, new Const.IntValue(utf8)));
        this.stringPool.put(utf8, index);
        return index;
    }

    private int insert(Entry key) {
        int entry = this.nextEntry;
        this.constants.add(key);
        this.nextEntry += ConstantPool.width(key.kind());
        if ((this.nextEntry & 0xFFFF) != this.nextEntry) {
            throw new AssertionError((Object)"constant pool has more than 2^16 entries");
        }
        return entry;
    }

    static enum Kind {
        CLASS_INFO(7),
        STRING(8),
        INTEGER(3),
        DOUBLE(6),
        FLOAT(4),
        LONG(5),
        UTF8(1);

        private final short tag;

        private Kind(int tag) {
            this.tag = (short)tag;
        }

        public short tag() {
            return this.tag;
        }
    }

    static class Entry {
        private final Kind kind;
        private final Const.Value value;

        Entry(Kind kind, Const.Value value) {
            this.kind = kind;
            this.value = value;
        }

        public Kind kind() {
            return this.kind;
        }

        public Const.Value value() {
            return this.value;
        }
    }
}

