/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.binder.bound;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import com.google.turbine.binder.sym.ClassSymbol;
import java.lang.annotation.ElementType;
import java.lang.annotation.RetentionPolicy;
import java.util.EnumSet;

public class AnnotationMetadata {
    private static final ImmutableSet<ElementType> DEFAULT_TARGETS = AnnotationMetadata.getDefaultElements();
    private final RetentionPolicy retention;
    private final ImmutableSet<ElementType> target;
    private final ClassSymbol repeatable;

    private static ImmutableSet<ElementType> getDefaultElements() {
        EnumSet<ElementType> values = EnumSet.allOf(ElementType.class);
        values.remove((Object)ElementType.TYPE_PARAMETER);
        values.remove((Object)ElementType.TYPE_USE);
        return ImmutableSet.copyOf(values);
    }

    public AnnotationMetadata(RetentionPolicy retention, ImmutableSet<ElementType> annotationTarget, ClassSymbol repeatable) {
        this.retention = (RetentionPolicy)((Object)MoreObjects.firstNonNull((Object)((Object)retention), (Object)((Object)RetentionPolicy.CLASS)));
        this.target = (ImmutableSet)MoreObjects.firstNonNull(annotationTarget, DEFAULT_TARGETS);
        this.repeatable = repeatable;
    }

    public RetentionPolicy retention() {
        return this.retention;
    }

    public ImmutableSet<ElementType> target() {
        return this.target;
    }

    public ClassSymbol repeatable() {
        return this.repeatable;
    }
}

