/* This file is part of the Chakra project

   Copyright (C) 2010 Lukas Appelhans <l.appelhans@gmx.de>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
*/

#ifndef AKABEIPLAINDOWNLOADOPERATION_H
#define AKABEIPLAINDOWNLOADOPERATION_H

#include "akabeiclient_global.h"
#include <akabeioperation.h>
#include <akabeicache.h>
#include <QNetworkReply>
#include <QObject>

namespace Akabei {
    class Package;
}

namespace AkabeiClient {
class AKABEICLIENTSHARED_EXPORT PlainDownloadOperation : public Akabei::Operation
{
    Q_OBJECT
    Q_DISABLE_COPY(PlainDownloadOperation)
public:
    explicit PlainDownloadOperation(Akabei::Package *package, bool force = false);
    virtual ~PlainDownloadOperation();

Q_SIGNALS:
    void downloadedBytesChanged(Akabei::Package * pkg, qint64 bytes);
    void totalBytesChanged(Akabei::Package * pkg, qint64 totalBytes);
    void downloadSpeedChanged(Akabei::Package * pkg, qint64 bytesPerSecond);

protected:
    void validate();
    void run();

private:
    class Private;
    Private * const d;

    Q_PRIVATE_SLOT(d, void __k__updateProgress(int))
    Q_PRIVATE_SLOT(d, void __k__finished(bool))
    Q_PRIVATE_SLOT(d, void __k__updateSpeed(ulong))
    Q_PRIVATE_SLOT(d, void __k__updateDownloadedBytes(qint64))
    Q_PRIVATE_SLOT(d, void __k__updateTotalBytes(qint64))
    Q_PRIVATE_SLOT(d, void __k__updateEta(int))
};

}

#endif // AKABEIPLAINDOWNLOADOPERATION_H
