/* This file is part of the Chakra project

   Copyright (C) 2010 Lukas Appelhans <l.appelhans@gmx.de>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
*/
#ifndef AKABEICLIENTCONFIGURATION_H
#define AKABEICLIENTCONFIGURATION_H

#include "akabeiclient_global.h"
#include <QObject>
#include <QUrl>
#include <akabeidatabase.h>

namespace AkabeiClient {
class ConfigurationPrivate;
class DatabaseHandler;
/**
 * \class Configuration akabeiclientconfiguration.h "akabeiclientconfiguration.h"
 *
 * \brief This class handles all access to the config file
 *
 * This class is used to handle all configuration issues. It reads both settings and databases
 * from the config file.
 * All properties which are solely used in AkabeiClient are available through methods, other properties
 * can be read using the Akabei::Config class.
 * 
 * This class is thread-safe.
 */
class AKABEICLIENTSHARED_EXPORT Configuration : public QObject
{
    Q_OBJECT
    Q_DECLARE_PRIVATE(Configuration)
    friend class Backend;
    public:
        /**
         * @returns the Configuration singleton
         */
        static Configuration *instance();
        virtual ~Configuration();

        /**
         * Adds a database to the akabei instance
         * @returns the DatabaseHandler for the given database
         */
        DatabaseHandler * addMirror(const QUrl &mirror, const QString &dbname);
        /**
         * Removes a database from the akabei instance
         * @param handler the datase to be removed
         */
        void removeMirror(DatabaseHandler * handler);
        /**
         * @returns a number of package for which akabei should ask the user whether to remove them or not
         */
        QStringList holdPkg() const;
        /**
         * @returns a number of packages which akabei should ignore when upgrading
         */
        QStringList ignorePkg() const;
        /**
         * @returns a number of groups which akabei should ignore when upgrading
         */
        QStringList ignoreGroup() const;
        /**
         * @returns a number of packages which are supposed to be upgraded before all other packages
         */
        QStringList syncFirst() const;

    private:
        Configuration(QObject * parent = 0);
        ConfigurationPrivate *d_ptr;
};
}

#endif
