/* This file is part of the Chakra project

   Copyright (C) 2010 Dario Freddi <drf@chakra-project.org>
   Copyright (C) 2010 Lukas Appelhans <l.appelhans@gmx.de>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
*/

#ifndef AKABEICLIENT_GLOBAL_H
#define AKABEICLIENT_GLOBAL_H

#include <QtCore/qglobal.h>
#include <QUrl>

#if defined(AKABEICLIENT_LIBRARY)
#  define AKABEICLIENTSHARED_EXPORT Q_DECL_EXPORT
#else
#  define AKABEICLIENTSHARED_EXPORT Q_DECL_IMPORT
#endif

namespace AkabeiClient {
enum PackageAction
{
    Install = 0x00,
    Update = 0x01,
    Remove = 0x02,
    Replace = 0x03
};

const QUrl DEFAULT_CONFIG_FILE = QUrl(QLatin1String("/etc/akabei.conf"));
const QString DEFAULT_LOG_FILE = QLatin1String("var/log/akabei.log");
}

#endif // AKABEICLIENT_GLOBAL_H
