/*
 * Decompiled with CFR 0.152.
 */
package pax;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import org.pdfbox.cos.COSArray;
import org.pdfbox.cos.COSBase;
import org.pdfbox.cos.COSBoolean;
import org.pdfbox.cos.COSDictionary;
import org.pdfbox.cos.COSDocument;
import org.pdfbox.cos.COSFloat;
import org.pdfbox.cos.COSInteger;
import org.pdfbox.cos.COSName;
import org.pdfbox.cos.COSNull;
import org.pdfbox.cos.COSStream;
import org.pdfbox.cos.COSString;
import org.pdfbox.cos.ICOSVisitor;
import org.pdfbox.exceptions.COSVisitorException;

public class StringVisitor
implements ICOSVisitor {
    protected StringBuffer buf = new StringBuffer();
    boolean nodelim = false;

    public Object visitFromNull(COSNull cOSNull) {
        if (this.nodelim) {
            this.buf.append(' ');
        }
        this.buf.append("null");
        this.nodelim = true;
        return this.buf;
    }

    public Object visitFromBoolean(COSBoolean cOSBoolean) {
        if (this.nodelim) {
            this.buf.append(' ');
        }
        this.buf.append(cOSBoolean.getValue());
        this.nodelim = true;
        return this.buf;
    }

    public Object visitFromInt(COSInteger cOSInteger) {
        if (this.nodelim) {
            this.buf.append(' ');
        }
        this.buf.append(cOSInteger.intValue());
        this.nodelim = true;
        return this.buf;
    }

    public Object visitFromFloat(COSFloat cOSFloat) {
        String string;
        if (this.nodelim) {
            this.buf.append(' ');
        }
        if ((string = "" + cOSFloat.floatValue()).endsWith(".0")) {
            this.buf.append(string.substring(0, string.length() - ".0".length()));
        } else {
            this.buf.append(string);
        }
        this.nodelim = true;
        return this.buf;
    }

    public Object visitFromName(COSName cOSName) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            cOSName.writePDF((OutputStream)byteArrayOutputStream);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.buf.append(byteArrayOutputStream.toString());
        this.nodelim = true;
        return this.buf;
    }

    public Object visitFromString(COSString cOSString) {
        this.buf.append("\\<");
        this.buf.append(cOSString.getHexString());
        this.buf.append("\\>");
        this.nodelim = false;
        return this.buf;
    }

    public Object visitFromArray(COSArray cOSArray) throws COSVisitorException {
        this.buf.append('[');
        this.nodelim = false;
        for (int i = 0; i < cOSArray.size(); ++i) {
            cOSArray.getObject(i).accept((ICOSVisitor)this);
        }
        this.buf.append(']');
        this.nodelim = false;
        return this.buf;
    }

    public Object visitFromDictionary(COSDictionary cOSDictionary) throws COSVisitorException {
        this.buf.append("<<");
        this.nodelim = false;
        Iterator iterator = cOSDictionary.keyList().iterator();
        while (iterator.hasNext()) {
            COSName cOSName = (COSName)iterator.next();
            COSBase cOSBase = cOSDictionary.getDictionaryObject(cOSName);
            cOSName.accept((ICOSVisitor)this);
            cOSBase.accept((ICOSVisitor)this);
        }
        this.buf.append(">>");
        this.nodelim = false;
        return this.buf;
    }

    public Object visitFromStream(COSStream cOSStream) throws COSVisitorException {
        throw new COSVisitorException(new Exception("Unsupported stream object"));
    }

    public Object visitFromDocument(COSDocument cOSDocument) throws COSVisitorException {
        throw new COSVisitorException(new Exception("Unsupported documetn object"));
    }
}

