/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.bib2gls;

import com.dickimawbooks.bib2gls.Bib2Gls;
import com.dickimawbooks.bib2gls.Bib2GlsEntry;
import com.dickimawbooks.bib2gls.Bib2GlsEntryLetterComparator;
import com.dickimawbooks.bib2gls.SortSettings;
import java.util.Vector;
import java.util.regex.Matcher;

public class Bib2GlsEntryLetterNumberComparator
extends Bib2GlsEntryLetterComparator {
    public static final int NUMBER_BEFORE_LETTER = 0;
    public static final int NUMBER_AFTER_LETTER = 1;
    public static final int NUMBER_BETWEEN = 2;
    public static final int NUMBER_FIRST = 3;
    public static final int NUMBER_LAST = 4;
    public static final int PUNCTUATION_SPACE_FIRST = 0;
    public static final int PUNCTUATION_SPACE_LAST = 1;
    public static final int SPACE_PUNCTUATION_FIRST = 2;
    public static final int SPACE_PUNCTUATION_LAST = 3;
    public static final int SPACE_FIRST_PUNCTUATION_LAST = 4;
    public static final int PUNCTUATION_FIRST_SPACE_LAST = 5;
    public static final int PUNCTUATION_FIRST_SPACE_ZERO = 6;
    public static final int PUNCTUATION_LAST_SPACE_ZERO = 7;
    public static final int PUNCTUATION_FIRST_SPACE_ZERO_MATCH_NEXT = 8;
    public static final int PUNCTUATION_LAST_SPACE_ZERO_MATCH_NEXT = 9;
    private int numberPosition;
    private int puncPosition;

    public Bib2GlsEntryLetterNumberComparator(Bib2Gls bib2Gls, Vector<Bib2GlsEntry> vector, SortSettings sortSettings, String string, String string2, String string3) {
        super(bib2Gls, vector, sortSettings, string, string2, string3);
        this.numberPosition = sortSettings.getLetterNumberRule();
        switch (this.numberPosition) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid number option: " + this.numberPosition);
            }
        }
        this.puncPosition = sortSettings.getLetterNumberPuncRule();
        switch (this.puncPosition) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid punctuation option: " + this.puncPosition);
            }
        }
    }

    @Override
    protected String adjustSort(Bib2GlsEntry bib2GlsEntry, String string) {
        if (this.puncPosition == 6 || this.puncPosition == 7 || this.puncPosition == 8 || this.puncPosition == 9) {
            int n = string.length();
            if (n == 0) {
                return string;
            }
            boolean bl = this.puncPosition == 8 || this.puncPosition == 9;
            StringBuilder stringBuilder = new StringBuilder(n);
            int n2 = 0;
            while (n2 < n) {
                int n3 = string.codePointAt(n2);
                n2 += Character.charCount(n3);
                if (Character.isWhitespace(n3)) {
                    int n4 = n2 < n ? string.codePointAt(n2) : 0;
                    n3 = 48;
                    if (n4 > 127 && bl) {
                        if (Character.isDigit(n4)) {
                            try {
                                int n5 = n4 - Integer.valueOf(String.format("%c", n4));
                                if (Integer.valueOf(String.format("%c", n5)) == 0) {
                                    n3 = n5;
                                }
                            }
                            catch (NumberFormatException numberFormatException) {
                                this.bib2gls.debug(numberFormatException);
                            }
                        } else if (Bib2Gls.isSubscriptDigit(n4)) {
                            n3 = 8320;
                        } else if (Bib2Gls.isSuperscriptDigit(n4)) {
                            n3 = 8304;
                        }
                    }
                }
                stringBuilder.appendCodePoint(n3);
            }
            string = stringBuilder.toString();
        }
        return super.adjustSort(bib2GlsEntry, string);
    }

    @Override
    protected int compare(int n, int n2) {
        boolean bl;
        boolean bl2 = Character.isLetter(n);
        boolean bl3 = Character.isLetter(n2);
        if (bl2 && bl3) {
            return super.compare(n, n2);
        }
        boolean bl4 = Character.isWhitespace(n);
        boolean bl5 = Character.isWhitespace(n2);
        boolean bl6 = !bl4 && !bl2;
        boolean bl7 = bl = !bl5 && !bl3;
        if (bl4 && bl5 || bl6 && bl) {
            if (n < n2) {
                return -1;
            }
            if (n > n2) {
                return 1;
            }
            return 0;
        }
        if (bl4 && bl) {
            switch (this.puncPosition) {
                case 0: 
                case 1: 
                case 5: 
                case 6: 
                case 8: {
                    return 1;
                }
                case 2: 
                case 3: 
                case 4: 
                case 7: 
                case 9: {
                    return -1;
                }
            }
            throw new IllegalArgumentException("Invalid letter-number-punc setting: " + this.puncPosition);
        }
        if (bl6 && bl5) {
            switch (this.puncPosition) {
                case 0: 
                case 1: 
                case 5: 
                case 6: 
                case 8: {
                    return -1;
                }
                case 2: 
                case 3: 
                case 4: 
                case 7: 
                case 9: {
                    return 1;
                }
            }
            throw new IllegalArgumentException("Invalid letter-number-punc setting: " + this.puncPosition);
        }
        if (bl2) {
            switch (this.puncPosition) {
                case 0: 
                case 2: {
                    return 1;
                }
                case 1: 
                case 3: {
                    return -1;
                }
                case 5: {
                    if (bl) {
                        return 1;
                    }
                    return -1;
                }
                case 6: 
                case 8: {
                    return 1;
                }
                case 4: {
                    if (bl5) {
                        return 1;
                    }
                    return -1;
                }
                case 7: 
                case 9: {
                    return -1;
                }
            }
            throw new IllegalArgumentException("Invalid letter-number-punc setting: " + this.puncPosition);
        }
        switch (this.puncPosition) {
            case 0: 
            case 2: {
                return -1;
            }
            case 1: 
            case 3: {
                return 1;
            }
            case 5: {
                if (bl6) {
                    return -1;
                }
                return 1;
            }
            case 6: 
            case 8: {
                return -1;
            }
            case 4: {
                if (bl4) {
                    return -1;
                }
                return 1;
            }
            case 7: 
            case 9: {
                return 1;
            }
        }
        throw new IllegalArgumentException("Invalid letter-number-punc setting: " + this.puncPosition);
    }

    private int compareNumberChar(int n) {
        if (this.numberPosition == 3) {
            return -1;
        }
        if (this.numberPosition == 4) {
            return 1;
        }
        if (Character.isLetter(n)) {
            return this.compareNumberLetter(n);
        }
        switch (this.puncPosition) {
            case 0: 
            case 2: 
            case 6: 
            case 8: {
                return 1;
            }
            case 1: 
            case 3: 
            case 7: 
            case 9: {
                return -1;
            }
            case 4: {
                return Character.isWhitespace(n) ? 1 : -1;
            }
            case 5: {
                return Character.isWhitespace(n) ? -1 : 1;
            }
        }
        throw new IllegalArgumentException("Invalid letter-number-punc setting: " + this.puncPosition);
    }

    private int compareNumberLetter(int n) {
        int n2 = 0;
        block0 : switch (this.numberPosition) {
            case 0: {
                n2 = -1;
                break;
            }
            case 1: {
                n2 = 1;
                break;
            }
            case 2: {
                switch (this.caseStyle) {
                    case 0: 
                    case 2: {
                        n2 = Character.isUpperCase(n) || Character.isTitleCase(n) ? 1 : -1;
                        break block0;
                    }
                    case 1: {
                        n2 = Character.isLowerCase(n) ? -1 : 1;
                        break block0;
                    }
                    case 3: {
                        n2 = Character.isLowerCase(n) ? 1 : -1;
                        break block0;
                    }
                }
                throw new IllegalArgumentException("Invalid case setting: " + this.caseStyle);
            }
            case 3: {
                n2 = -1;
                break;
            }
            case 4: {
                n2 = 1;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid letter-number setting: " + this.numberPosition);
            }
        }
        return n2;
    }

    @Override
    protected int compare(String string, String string2) {
        int n = string.length();
        int n2 = string2.length();
        int n3 = 0;
        int n4 = 0;
        while (n3 < n && n4 < n2) {
            int n5;
            Matcher matcher = Bib2Gls.INT_PATTERN.matcher(string.substring(n3));
            Integer n6 = null;
            Integer n7 = null;
            if (matcher.matches()) {
                try {
                    n6 = Bib2Gls.parseInt(matcher.group(1));
                    n3 += matcher.end(1);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if ((matcher = Bib2Gls.INT_PATTERN.matcher(string2.substring(n4))).matches()) {
                try {
                    n7 = Bib2Gls.parseInt(matcher.group(1));
                    n4 += matcher.end(1);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (n6 != null || n7 != null) {
                n5 = n6 == null ? -this.compareNumberChar(string.codePointAt(n3)) : (n7 == null ? this.compareNumberChar(string2.codePointAt(n4)) : n6.compareTo(n7));
                if (n5 == 0) continue;
                return n5;
            }
            n5 = string.codePointAt(n3);
            int n8 = string2.codePointAt(n4);
            n3 += Character.charCount(n5);
            n4 += Character.charCount(n8);
            int n9 = this.compare(n5, n8);
            if (n9 == 0) continue;
            return n9;
        }
        return n == n2 ? 0 : (n < n2 ? -1 : 1);
    }
}

