// This file is generated by kconfig_compiler_kf5 from okular_core.kcfg.
// All changes you do to this file will be lost.

#include "settings_core.h"

#include <qglobal.h>
#include <QFile>

#include <QDebug>

using namespace Okular;

namespace Okular {

class SettingsCorePrivate
{
  public:

    // Core Performance
    int memoryLevel;
    bool enableThreading;
    int textAntialias;
    int graphicsAntialias;
    int textHinting;

    // Document
    QColor paperColor;
    bool changeColors;
    int renderMode;

    // Core General
    bool obeyDRM;
    bool chooseGenerators;
    int externalEditor;
    QString externalEditorCommand;

    // Core Presentation
    bool slidesAdvance;
    uint slidesAdvanceTime;
    bool slidesLoop;
    int slidesTapNavigation;

    // items
    KConfigSkeleton::ItemEnum *itemMemoryLevel;
    KConfigSkeleton::ItemBool *itemEnableThreading;
    KConfigSkeleton::ItemEnum *itemTextAntialias;
    KConfigSkeleton::ItemEnum *itemGraphicsAntialias;
    KConfigSkeleton::ItemEnum *itemTextHinting;
    KConfigSkeleton::ItemColor *itemPaperColor;
    KConfigSkeleton::ItemBool *itemChangeColors;
    KConfigSkeleton::ItemEnum *itemRenderMode;
    KConfigSkeleton::ItemBool *itemObeyDRM;
    KConfigSkeleton::ItemBool *itemChooseGenerators;
    KConfigSkeleton::ItemEnum *itemExternalEditor;
    KConfigSkeleton::ItemString *itemExternalEditorCommand;
    KConfigSkeleton::ItemBool *itemSlidesAdvance;
    KConfigSkeleton::ItemUInt *itemSlidesAdvanceTime;
    KConfigSkeleton::ItemBool *itemSlidesLoop;
    KConfigSkeleton::ItemEnum *itemSlidesTapNavigation;
};

}

namespace Okular {

class SettingsCoreHelper
{
  public:
    SettingsCoreHelper() : q(nullptr) {}
    ~SettingsCoreHelper() { delete q; }
    SettingsCoreHelper(const SettingsCoreHelper&) = delete;
    SettingsCoreHelper& operator=(const SettingsCoreHelper&) = delete;
    SettingsCore *q;
};
}

Q_GLOBAL_STATIC(SettingsCoreHelper, s_globalSettingsCore)
SettingsCore *SettingsCore::self()
{
  if (!s_globalSettingsCore()->q)
     qFatal("you need to call SettingsCore::instance before using");
  return s_globalSettingsCore()->q;
}

void SettingsCore::instance(const QString& cfgfilename)
{
  if (s_globalSettingsCore()->q) {
     qDebug() << "SettingsCore::instance called after the first use - ignoring";
     return;
  }
  new SettingsCore(KSharedConfig::openConfig(cfgfilename));
  s_globalSettingsCore()->q->read();
}

void SettingsCore::instance(KSharedConfig::Ptr config)
{
  if (s_globalSettingsCore()->q) {
     qDebug() << "SettingsCore::instance called after the first use - ignoring";
     return;
  }
  new SettingsCore(std::move(config));
  s_globalSettingsCore()->q->read();
}

SettingsCore::SettingsCore( KSharedConfig::Ptr config )
  : KConfigSkeleton( std::move( config ) )
{
  d = new SettingsCorePrivate;
  Q_ASSERT(!s_globalSettingsCore()->q);
  s_globalSettingsCore()->q = this;
  setCurrentGroup( QStringLiteral( "Core Performance" ) );

  QList<KConfigSkeleton::ItemEnum::Choice> valuesMemoryLevel;
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("Low");
    valuesMemoryLevel.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("Normal");
    valuesMemoryLevel.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("Aggressive");
    valuesMemoryLevel.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("Greedy");
    valuesMemoryLevel.append( choice );
  }
  d->itemMemoryLevel = new KConfigSkeleton::ItemEnum( currentGroup(), QStringLiteral( "MemoryLevel" ), d->memoryLevel, valuesMemoryLevel, EnumMemoryLevel::Normal );
  addItem( d->itemMemoryLevel, QStringLiteral( "MemoryLevel" ) );
  d->itemEnableThreading = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "EnableThreading" ), d->enableThreading, true );
  addItem( d->itemEnableThreading, QStringLiteral( "EnableThreading" ) );
  QList<KConfigSkeleton::ItemEnum::Choice> valuesTextAntialias;
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("Disabled");
    valuesTextAntialias.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("Enabled");
    valuesTextAntialias.append( choice );
  }
  d->itemTextAntialias = new KConfigSkeleton::ItemEnum( currentGroup(), QStringLiteral( "TextAntialias" ), d->textAntialias, valuesTextAntialias, EnumTextAntialias::Enabled );
  addItem( d->itemTextAntialias, QStringLiteral( "TextAntialias" ) );
  QList<KConfigSkeleton::ItemEnum::Choice> valuesGraphicsAntialias;
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("Disabled");
    valuesGraphicsAntialias.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("Enabled");
    valuesGraphicsAntialias.append( choice );
  }
  d->itemGraphicsAntialias = new KConfigSkeleton::ItemEnum( currentGroup(), QStringLiteral( "GraphicsAntialias" ), d->graphicsAntialias, valuesGraphicsAntialias, EnumGraphicsAntialias::Enabled );
  addItem( d->itemGraphicsAntialias, QStringLiteral( "GraphicsAntialias" ) );
  QList<KConfigSkeleton::ItemEnum::Choice> valuesTextHinting;
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("Disabled");
    valuesTextHinting.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("Enabled");
    valuesTextHinting.append( choice );
  }
  d->itemTextHinting = new KConfigSkeleton::ItemEnum( currentGroup(), QStringLiteral( "TextHinting" ), d->textHinting, valuesTextHinting, EnumTextHinting::Disabled );
  addItem( d->itemTextHinting, QStringLiteral( "TextHinting" ) );

  setCurrentGroup( QStringLiteral( "Document" ) );

  d->itemPaperColor = new KConfigSkeleton::ItemColor( currentGroup(), QStringLiteral( "PaperColor" ), d->paperColor, Qt::white );
  addItem( d->itemPaperColor, QStringLiteral( "PaperColor" ) );
  d->itemChangeColors = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "ChangeColors" ), d->changeColors, false );
  addItem( d->itemChangeColors, QStringLiteral( "ChangeColors" ) );
  QList<KConfigSkeleton::ItemEnum::Choice> valuesRenderMode;
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("Inverted");
    valuesRenderMode.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("Paper");
    valuesRenderMode.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("Recolor");
    valuesRenderMode.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("BlackWhite");
    valuesRenderMode.append( choice );
  }
  d->itemRenderMode = new KConfigSkeleton::ItemEnum( currentGroup(), QStringLiteral( "RenderMode" ), d->renderMode, valuesRenderMode, EnumRenderMode::Inverted );
  addItem( d->itemRenderMode, QStringLiteral( "RenderMode" ) );

  setCurrentGroup( QStringLiteral( "Core General" ) );

  d->itemObeyDRM = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "ObeyDRM" ), d->obeyDRM, true );
  addItem( d->itemObeyDRM, QStringLiteral( "ObeyDRM" ) );
  d->itemChooseGenerators = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "ChooseGenerators" ), d->chooseGenerators, false );
  addItem( d->itemChooseGenerators, QStringLiteral( "ChooseGenerators" ) );
  QList<KConfigSkeleton::ItemEnum::Choice> valuesExternalEditor;
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("Custom");
    valuesExternalEditor.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("Kate");
    valuesExternalEditor.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("Kile");
    valuesExternalEditor.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("Scite");
    valuesExternalEditor.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("Emacsclient");
    valuesExternalEditor.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("Lyxclient");
    valuesExternalEditor.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("Texstudio");
    valuesExternalEditor.append( choice );
  }
  d->itemExternalEditor = new KConfigSkeleton::ItemEnum( currentGroup(), QStringLiteral( "ExternalEditor" ), d->externalEditor, valuesExternalEditor, EnumExternalEditor::Kate );
  addItem( d->itemExternalEditor, QStringLiteral( "ExternalEditor" ) );
  d->itemExternalEditorCommand = new KConfigSkeleton::ItemString( currentGroup(), QStringLiteral( "ExternalEditorCommand" ), d->externalEditorCommand, QStringLiteral( "kate --line %l --column %c" ) );
  addItem( d->itemExternalEditorCommand, QStringLiteral( "ExternalEditorCommand" ) );

  setCurrentGroup( QStringLiteral( "Core Presentation" ) );

  d->itemSlidesAdvance = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "SlidesAdvance" ), d->slidesAdvance, false );
  addItem( d->itemSlidesAdvance, QStringLiteral( "SlidesAdvance" ) );
  d->itemSlidesAdvanceTime = new KConfigSkeleton::ItemUInt( currentGroup(), QStringLiteral( "SlidesAdvanceTime" ), d->slidesAdvanceTime, 5 );
  d->itemSlidesAdvanceTime->setMinValue(1);
  d->itemSlidesAdvanceTime->setMaxValue(3600);
  addItem( d->itemSlidesAdvanceTime, QStringLiteral( "SlidesAdvanceTime" ) );
  d->itemSlidesLoop = new KConfigSkeleton::ItemBool( currentGroup(), QStringLiteral( "SlidesLoop" ), d->slidesLoop, false );
  addItem( d->itemSlidesLoop, QStringLiteral( "SlidesLoop" ) );
  QList<KConfigSkeleton::ItemEnum::Choice> valuesSlidesTapNavigation;
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("ForwardBackward");
    valuesSlidesTapNavigation.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("Forward");
    valuesSlidesTapNavigation.append( choice );
  }
  {
    KConfigSkeleton::ItemEnum::Choice choice;
    choice.name = QStringLiteral("Disabled");
    valuesSlidesTapNavigation.append( choice );
  }
  d->itemSlidesTapNavigation = new KConfigSkeleton::ItemEnum( currentGroup(), QStringLiteral( "SlidesTapNavigation" ), d->slidesTapNavigation, valuesSlidesTapNavigation, EnumSlidesTapNavigation::Forward );
  addItem( d->itemSlidesTapNavigation, QStringLiteral( "SlidesTapNavigation" ) );
}

void SettingsCore::setMemoryLevel( int v )
{
      if (!self()->isImmutable( QStringLiteral( "MemoryLevel" ) ))
        self()->d->memoryLevel = v;
}

int SettingsCore::memoryLevel()
{
  return self()->d->memoryLevel;
}


void SettingsCore::setEnableThreading( bool v )
{
      if (!self()->isImmutable( QStringLiteral( "EnableThreading" ) ))
        self()->d->enableThreading = v;
}

bool SettingsCore::enableThreading()
{
  return self()->d->enableThreading;
}


void SettingsCore::setTextAntialias( int v )
{
      if (!self()->isImmutable( QStringLiteral( "TextAntialias" ) ))
        self()->d->textAntialias = v;
}

int SettingsCore::textAntialias()
{
  return self()->d->textAntialias;
}


void SettingsCore::setGraphicsAntialias( int v )
{
      if (!self()->isImmutable( QStringLiteral( "GraphicsAntialias" ) ))
        self()->d->graphicsAntialias = v;
}

int SettingsCore::graphicsAntialias()
{
  return self()->d->graphicsAntialias;
}


void SettingsCore::setTextHinting( int v )
{
      if (!self()->isImmutable( QStringLiteral( "TextHinting" ) ))
        self()->d->textHinting = v;
}

int SettingsCore::textHinting()
{
  return self()->d->textHinting;
}


void SettingsCore::setPaperColor( const QColor & v )
{
      if (!self()->isImmutable( QStringLiteral( "PaperColor" ) ))
        self()->d->paperColor = v;
}

QColor SettingsCore::paperColor()
{
  return self()->d->paperColor;
}


void SettingsCore::setChangeColors( bool v )
{
      if (!self()->isImmutable( QStringLiteral( "ChangeColors" ) ))
        self()->d->changeColors = v;
}

bool SettingsCore::changeColors()
{
  return self()->d->changeColors;
}


void SettingsCore::setRenderMode( int v )
{
      if (!self()->isImmutable( QStringLiteral( "RenderMode" ) ))
        self()->d->renderMode = v;
}

int SettingsCore::renderMode()
{
  return self()->d->renderMode;
}


void SettingsCore::setObeyDRM( bool v )
{
      if (!self()->isImmutable( QStringLiteral( "ObeyDRM" ) ))
        self()->d->obeyDRM = v;
}

bool SettingsCore::obeyDRM()
{
  return self()->d->obeyDRM;
}


void SettingsCore::setChooseGenerators( bool v )
{
      if (!self()->isImmutable( QStringLiteral( "ChooseGenerators" ) ))
        self()->d->chooseGenerators = v;
}

bool SettingsCore::chooseGenerators()
{
  return self()->d->chooseGenerators;
}


void SettingsCore::setExternalEditor( int v )
{
      if (!self()->isImmutable( QStringLiteral( "ExternalEditor" ) ))
        self()->d->externalEditor = v;
}

int SettingsCore::externalEditor()
{
  return self()->d->externalEditor;
}


void SettingsCore::setExternalEditorCommand( const QString & v )
{
      if (!self()->isImmutable( QStringLiteral( "ExternalEditorCommand" ) ))
        self()->d->externalEditorCommand = v;
}

QString SettingsCore::externalEditorCommand()
{
  return self()->d->externalEditorCommand;
}


void SettingsCore::setSlidesAdvance( bool v )
{
      if (!self()->isImmutable( QStringLiteral( "SlidesAdvance" ) ))
        self()->d->slidesAdvance = v;
}

bool SettingsCore::slidesAdvance()
{
  return self()->d->slidesAdvance;
}


void SettingsCore::setSlidesAdvanceTime( uint v )
{
      if (v < 1)
      {
        qDebug() << "setSlidesAdvanceTime: value " << v << " is less than the minimum value of 1";
        v = 1;
      }

      if (v > 3600)
      {
        qDebug() << "setSlidesAdvanceTime: value " << v << " is greater than the maximum value of 3600";
        v = 3600;
      }

      if (!self()->isImmutable( QStringLiteral( "SlidesAdvanceTime" ) ))
        self()->d->slidesAdvanceTime = v;
}

uint SettingsCore::slidesAdvanceTime()
{
  return self()->d->slidesAdvanceTime;
}


void SettingsCore::setSlidesLoop( bool v )
{
      if (!self()->isImmutable( QStringLiteral( "SlidesLoop" ) ))
        self()->d->slidesLoop = v;
}

bool SettingsCore::slidesLoop()
{
  return self()->d->slidesLoop;
}


void SettingsCore::setSlidesTapNavigation( int v )
{
      if (!self()->isImmutable( QStringLiteral( "SlidesTapNavigation" ) ))
        self()->d->slidesTapNavigation = v;
}

int SettingsCore::slidesTapNavigation()
{
  return self()->d->slidesTapNavigation;
}


SettingsCore::~SettingsCore()
{
  delete d;
  s_globalSettingsCore()->q = nullptr;
}

