/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.pdmodel;

import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.List;
import org.pdfbox.cos.COSArray;
import org.pdfbox.cos.COSBase;
import org.pdfbox.cos.COSDictionary;
import org.pdfbox.cos.COSDocument;
import org.pdfbox.cos.COSInteger;
import org.pdfbox.cos.COSName;
import org.pdfbox.cos.COSStream;
import org.pdfbox.exceptions.COSVisitorException;
import org.pdfbox.exceptions.CryptographyException;
import org.pdfbox.exceptions.InvalidPasswordException;
import org.pdfbox.io.RandomAccess;
import org.pdfbox.pdfparser.PDFParser;
import org.pdfbox.pdfwriter.COSWriter;
import org.pdfbox.pdmodel.PDDocumentCatalog;
import org.pdfbox.pdmodel.PDDocumentInformation;
import org.pdfbox.pdmodel.PDPage;
import org.pdfbox.pdmodel.PDPageNode;
import org.pdfbox.pdmodel.common.PDRectangle;
import org.pdfbox.pdmodel.common.PDStream;
import org.pdfbox.pdmodel.encryption.AccessPermission;
import org.pdfbox.pdmodel.encryption.BadSecurityHandlerException;
import org.pdfbox.pdmodel.encryption.DecryptionMaterial;
import org.pdfbox.pdmodel.encryption.PDEncryptionDictionary;
import org.pdfbox.pdmodel.encryption.ProtectionPolicy;
import org.pdfbox.pdmodel.encryption.SecurityHandler;
import org.pdfbox.pdmodel.encryption.SecurityHandlersManager;
import org.pdfbox.pdmodel.encryption.StandardDecryptionMaterial;
import org.pdfbox.pdmodel.encryption.StandardProtectionPolicy;

public class PDDocument
implements Pageable {
    private COSDocument document;
    private PDDocumentInformation documentInformation;
    private PDDocumentCatalog documentCatalog;
    private PDEncryptionDictionary encParameters = null;
    private SecurityHandler securityHandler = null;

    public PDDocument() throws IOException {
        this.document = new COSDocument();
        COSDictionary trailer = new COSDictionary();
        this.document.setTrailer(trailer);
        COSDictionary rootDictionary = new COSDictionary();
        trailer.setItem(COSName.ROOT, (COSBase)rootDictionary);
        rootDictionary.setItem(COSName.TYPE, (COSBase)COSName.CATALOG);
        rootDictionary.setItem(COSName.VERSION, (COSBase)COSName.getPDFName("1.4"));
        COSDictionary pages = new COSDictionary();
        rootDictionary.setItem(COSName.PAGES, (COSBase)pages);
        pages.setItem(COSName.TYPE, (COSBase)COSName.PAGES);
        COSArray kidsArray = new COSArray();
        pages.setItem(COSName.KIDS, (COSBase)kidsArray);
        pages.setItem(COSName.COUNT, (COSBase)new COSInteger(0));
    }

    public void addPage(PDPage page) {
        PDPageNode rootPages = this.getDocumentCatalog().getPages();
        rootPages.getKids().add(page);
        page.setParent(rootPages);
        rootPages.updateCount();
    }

    public boolean removePage(PDPage page) {
        PDPageNode parent = page.getParent();
        boolean retval = parent.getKids().remove(page);
        if (retval) {
            this.getDocumentCatalog().getPages().updateCount();
        }
        return retval;
    }

    public boolean removePage(int pageNumber) {
        boolean removed = false;
        List allPages = this.getDocumentCatalog().getAllPages();
        if (allPages.size() > pageNumber) {
            PDPage page = (PDPage)allPages.get(pageNumber);
            removed = this.removePage(page);
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PDPage importPage(PDPage page) throws IOException {
        PDPage importedPage = new PDPage(new COSDictionary(page.getCOSDictionary()));
        InputStream is = null;
        OutputStream os = null;
        try {
            PDStream src = page.getContents();
            PDStream dest = new PDStream(new COSStream(src.getStream(), this.document.getScratchFile()));
            importedPage.setContents(dest);
            os = dest.createOutputStream();
            byte[] buf = new byte[10240];
            int amountRead = 0;
            is = src.createInputStream();
            while ((amountRead = is.read(buf, 0, 10240)) > -1) {
                os.write(buf, 0, amountRead);
            }
            this.addPage(importedPage);
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (os != null) {
                os.close();
            }
        }
        return importedPage;
    }

    public PDDocument(COSDocument doc) {
        this.document = doc;
    }

    public COSDocument getDocument() {
        return this.document;
    }

    public PDDocumentInformation getDocumentInformation() {
        if (this.documentInformation == null) {
            COSDictionary trailer = this.document.getTrailer();
            COSDictionary infoDic = (COSDictionary)trailer.getDictionaryObject(COSName.INFO);
            if (infoDic == null) {
                infoDic = new COSDictionary();
                trailer.setItem(COSName.INFO, (COSBase)infoDic);
            }
            this.documentInformation = new PDDocumentInformation(infoDic);
        }
        return this.documentInformation;
    }

    public void setDocumentInformation(PDDocumentInformation info) {
        this.documentInformation = info;
        this.document.getTrailer().setItem(COSName.INFO, (COSBase)info.getDictionary());
    }

    public PDDocumentCatalog getDocumentCatalog() {
        if (this.documentCatalog == null) {
            COSDictionary trailer = this.document.getTrailer();
            COSDictionary infoDic = (COSDictionary)trailer.getDictionaryObject(COSName.ROOT);
            this.documentCatalog = infoDic == null ? new PDDocumentCatalog(this) : new PDDocumentCatalog(this, infoDic);
        }
        return this.documentCatalog;
    }

    public boolean isEncrypted() {
        return this.document.isEncrypted();
    }

    public PDEncryptionDictionary getEncryptionDictionary() throws IOException {
        if (this.encParameters == null) {
            this.encParameters = this.isEncrypted() ? new PDEncryptionDictionary(this.document.getEncryptionDictionary()) : new PDEncryptionDictionary();
        }
        return this.encParameters;
    }

    public void setEncryptionDictionary(PDEncryptionDictionary encDictionary) throws IOException {
        this.encParameters = encDictionary;
    }

    public boolean isUserPassword(String password) throws IOException, CryptographyException {
        return false;
    }

    public boolean isOwnerPassword(String password) throws IOException, CryptographyException {
        return false;
    }

    public void decrypt(String password) throws CryptographyException, IOException, InvalidPasswordException {
        try {
            StandardDecryptionMaterial m = new StandardDecryptionMaterial(password);
            this.openProtection(m);
            this.document.dereferenceObjectStreams();
        }
        catch (BadSecurityHandlerException e) {
            throw new CryptographyException(e);
        }
    }

    public boolean wasDecryptedWithOwnerPassword() {
        return false;
    }

    public void encrypt(String ownerPassword, String userPassword) throws CryptographyException, IOException {
        try {
            StandardProtectionPolicy policy = new StandardProtectionPolicy(ownerPassword, userPassword, new AccessPermission());
            this.protect(policy);
        }
        catch (BadSecurityHandlerException e) {
            throw new CryptographyException(e);
        }
    }

    public String getOwnerPasswordForEncryption() {
        return null;
    }

    public String getUserPasswordForEncryption() {
        return null;
    }

    public boolean willEncryptWhenSaving() {
        return false;
    }

    public void clearWillEncryptWhenSaving() {
    }

    public static PDDocument load(URL url) throws IOException {
        return PDDocument.load(url.openStream());
    }

    public static PDDocument load(URL url, RandomAccess scratchFile) throws IOException {
        return PDDocument.load(url.openStream(), scratchFile);
    }

    public static PDDocument load(String filename) throws IOException {
        return PDDocument.load(new FileInputStream(filename));
    }

    public static PDDocument load(String filename, RandomAccess scratchFile) throws IOException {
        return PDDocument.load(new FileInputStream(filename), scratchFile);
    }

    public static PDDocument load(File file) throws IOException {
        return PDDocument.load(new FileInputStream(file));
    }

    public static PDDocument load(File file, RandomAccess scratchFile) throws IOException {
        return PDDocument.load(new FileInputStream(file));
    }

    public static PDDocument load(InputStream input) throws IOException {
        return PDDocument.load(input, null);
    }

    public static PDDocument load(InputStream input, RandomAccess scratchFile) throws IOException {
        PDFParser parser = new PDFParser(new BufferedInputStream(input), scratchFile);
        parser.parse();
        return parser.getPDDocument();
    }

    public void save(String fileName) throws IOException, COSVisitorException {
        this.save(new FileOutputStream(fileName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(OutputStream output) throws IOException, COSVisitorException {
        this.getDocumentCatalog().getPages().updateCount();
        COSWriter writer = null;
        try {
            writer = new COSWriter(output);
            writer.write(this);
            writer.close();
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    public int getPageCount() {
        return this.getNumberOfPages();
    }

    public int getNumberOfPages() {
        PDDocumentCatalog cat = this.getDocumentCatalog();
        return (int)cat.getPages().getCount();
    }

    public PageFormat getPageFormat(int pageIndex) {
        double height;
        PDPage page = (PDPage)this.getDocumentCatalog().getAllPages().get(pageIndex);
        PDRectangle mediaBox = page.findMediaBox();
        PageFormat format = new PageFormat();
        Paper paper = new Paper();
        double width = mediaBox.getWidth();
        if (width > (height = (double)mediaBox.getHeight())) {
            format.setOrientation(0);
            width = mediaBox.getHeight();
            height = mediaBox.getWidth();
        }
        paper.setImageableArea(0.0, 0.0, width, height);
        paper.setSize(width, height);
        format.setPaper(paper);
        return format;
    }

    public Printable getPrintable(int pageIndex) {
        return (Printable)this.getDocumentCatalog().getAllPages().get(pageIndex);
    }

    public void print() throws PrinterException {
        AccessPermission currentPermissions = this.getCurrentAccessPermission();
        if (!currentPermissions.canPrint()) {
            throw new PrinterException("You do not have permission to print this document.");
        }
        PrinterJob printJob = PrinterJob.getPrinterJob();
        printJob.setPageable(this);
        if (printJob.printDialog()) {
            printJob.print();
        }
    }

    public void silentPrint() throws PrinterException {
        AccessPermission currentPermissions = this.getCurrentAccessPermission();
        if (!currentPermissions.canPrint()) {
            throw new PrinterException("You do not have permission to print this document.");
        }
        PrinterJob printJob = PrinterJob.getPrinterJob();
        printJob.setPageable(this);
        printJob.print();
    }

    public void close() throws IOException {
        this.document.close();
    }

    public void protect(ProtectionPolicy pp) throws BadSecurityHandlerException {
        SecurityHandler handler;
        this.securityHandler = handler = SecurityHandlersManager.getInstance().getSecurityHandler(pp);
    }

    public void openProtection(DecryptionMaterial pm) throws BadSecurityHandlerException, IOException, CryptographyException {
        SecurityHandler handler;
        PDEncryptionDictionary dict = this.getEncryptionDictionary();
        if (dict.getFilter() == null) {
            throw new RuntimeException("This document does not need to be decrypted");
        }
        this.securityHandler = handler = SecurityHandlersManager.getInstance().getSecurityHandler(dict.getFilter());
        handler.decryptDocument(this, pm);
        this.document.dereferenceObjectStreams();
    }

    public AccessPermission getCurrentAccessPermission() {
        if (this.securityHandler == null) {
            return AccessPermission.getOwnerAccessPermission();
        }
        return this.securityHandler.getCurrentAccessPermission();
    }

    public SecurityHandler getSecurityHandler() {
        return this.securityHandler;
    }
}

