/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.xml.actions;

import com.eviware.soapui.support.Tools;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.xml.JXEditTextArea;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.swing.AbstractAction;

public class LoadXmlTextAreaAction
extends AbstractAction {
    private final JXEditTextArea textArea;
    private String dialogTitle;

    public LoadXmlTextAreaAction(JXEditTextArea textArea, String dialogTitle) {
        super("Load from..");
        this.textArea = textArea;
        this.dialogTitle = dialogTitle;
        this.putValue("AcceleratorKey", UISupport.getKeyStroke("menu L"));
    }

    public void actionPerformed(ActionEvent e) {
        File file = UISupport.getFileDialogs().open(this, this.dialogTitle, ".xml", "XML Files (*.xml)", null);
        if (file == null) {
            return;
        }
        try {
            this.textArea.setText(Tools.readAll(new FileInputStream(file), 0L).toString());
        }
        catch (IOException e1) {
            UISupport.showErrorMessage("Error loading xml from file: " + e1.getMessage());
        }
    }
}

