/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.resolver;

import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.teststeps.PropertyTransfer;
import com.eviware.soapui.impl.wsdl.teststeps.PropertyTransfersTestStep;
import com.eviware.soapui.model.testsuite.TestProperty;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.resolver.ResolveContext;

public class CreateMissingPropertyResolver
implements ResolveContext.Resolver {
    private boolean resolved = false;
    private PropertyTransfersTestStep parentPropertyTestStep = null;
    private PropertyTransfer badTransfer = null;

    public CreateMissingPropertyResolver(PropertyTransfer transfer, PropertyTransfersTestStep parent) {
        this.parentPropertyTestStep = parent;
        this.badTransfer = transfer;
    }

    public String getDescription() {
        return "Create new property";
    }

    public String toString() {
        return this.getDescription();
    }

    public String getResolvedPath() {
        return null;
    }

    public boolean isResolved() {
        return this.resolved;
    }

    public boolean resolve() {
        WsdlProject project = this.parentPropertyTestStep.getTestCase().getTestSuite().getProject();
        String name = UISupport.prompt("Specify unique property name", "Add Property", "");
        if (StringUtils.hasContent(name)) {
            if (project.hasProperty(name)) {
                UISupport.showErrorMessage("Property name [" + name + "] already exists. Property transfer will be disabled.");
                this.badTransfer.setDisabled(true);
            } else {
                TestProperty newProperty = project.addProperty(name);
                name = UISupport.prompt("What is default value for property " + name, "Add Property Value", "");
                if (StringUtils.hasContent(name)) {
                    newProperty.setValue(name);
                } else {
                    newProperty.setValue(newProperty.getName());
                }
                this.badTransfer.setSourcePropertyName(newProperty.getName());
                this.resolved = true;
            }
        } else {
            UISupport.showInfoMessage("Canceled. Property transfer will be disabled.");
            this.badTransfer.setDisabled(true);
        }
        return this.resolved;
    }
}

